/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model;

import java.util.Date;
import ru.bgcrm.util.TimeUtils;

public class Period {
    private Date dateFrom;
    private Date dateTo;

    public Period() {
    }

    public Period(Date dateFrom, Date dateTo) {
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
    }

    public Period(String period) {
        int pos = period.indexOf(45);
        if (pos < 0) {
            throw new IllegalArgumentException("Period string doesn't contain '-'");
        }
        this.dateFrom = TimeUtils.parse(period.substring(0, pos), "ymd");
        this.dateTo = TimeUtils.parse(period.substring(pos + 1), "ymd");
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public String toString() {
        return TimeUtils.formatPeriod(this.dateFrom, this.dateTo);
    }
}

