/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.jsp;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.NotFoundException;
import org.bgerp.action.base.Actions;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.dist.inst.InstalledModule;
import org.bgerp.app.dist.inst.InstallerChanges;
import org.bgerp.app.servlet.jsp.tag.NewInstanceTag;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.util.Utils;

public class UtilFunction {
    private static final Log log = Log.getLog();
    private static final AtomicLong UIID = new AtomicLong(System.currentTimeMillis());
    private static final Pattern LINKS = Pattern.compile("\\(?\\bhttps?://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    public static Object newInstance(String className, Object ... args) throws Exception {
        if (args == null) {
            args = new Object[]{};
        }
        for (Constructor<?> constr : Bean.getClass(className).getDeclaredConstructors()) {
            Object[] convertedTypes;
            if (constr.getParameters().length != args.length || (convertedTypes = NewInstanceTag.convertObjectTypes(List.of(args), constr.getParameterTypes())) == null) continue;
            return constr.newInstance(convertedTypes);
        }
        throw new IllegalArgumentException(Log.format("Not found constructor for class '{}' with arguments '{}'", className, List.of(args)));
    }

    public static Object newInstance(String className) throws Exception {
        return UtilFunction.newInstance(className, (Object[])null);
    }

    public static Object newInstance(String className, Object arg0) throws Exception {
        return UtilFunction.newInstance(className, new Object[]{arg0});
    }

    public static Object newInstance(String className, Object arg0, Object arg1) throws Exception {
        return UtilFunction.newInstance(className, new Object[]{arg0, arg1});
    }

    public static Object newInstance(String className, Object arg0, Object arg1, Object arg2) throws Exception {
        return UtilFunction.newInstance(className, new Object[]{arg0, arg1, arg2});
    }

    private static boolean contains(Object collection, Object object) {
        if (collection == null || object == null) {
            return false;
        }
        if (collection instanceof Object[]) {
            for (Object val : (Object[])collection) {
                if (!val.equals(object)) continue;
                return true;
            }
        } else {
            if (collection instanceof Collection) {
                return ((Collection)collection).contains(object);
            }
            if (collection instanceof Map) {
                return ((Map)collection).containsKey(object);
            }
        }
        return collection.equals(object);
    }

    private static String string(Object collection, Object object, String string) {
        if (UtilFunction.contains(collection, object)) {
            return string;
        }
        return "";
    }

    private static String string(Boolean object, String string) {
        if (object != null && object.booleanValue()) {
            return string;
        }
        return "";
    }

    public static String checked(Object collection, Object object) {
        return UtilFunction.string(collection, object, "checked='1'");
    }

    public static String checked(Boolean object) {
        return UtilFunction.string(object, "checked='1'");
    }

    public static String selected(Object collection, Object object) {
        return UtilFunction.string(collection, object, "selected='1'");
    }

    public static String selected(Boolean object) {
        return UtilFunction.string(object, "selected='1'");
    }

    public static Integer getInt(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Utils.parseInt((String)value);
        }
        log.error("Incorrect object to int transformation: {}", value);
        return 0;
    }

    public static String uiid() {
        return "UIID" + UIID.incrementAndGet();
    }

    public static String urlEncode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
    }

    public static String htmlEncode(String value) {
        String result = value.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\n", "<br/>");
        result = result.replaceAll("\t", "    ");
        return result;
    }

    public static String httpLinksToHtml(String value) {
        Matcher m = null;
        int pos = 0;
        boolean foundInAttr = false;
        while ((m = LINKS.matcher((CharSequence)value)).find(pos)) {
            char nextChar;
            if (m.end() < ((String)value).length() && ((nextChar = ((String)value).charAt(m.end())) == '\"' || nextChar == '\'')) {
                pos = m.end();
                foundInAttr = true;
                continue;
            }
            if (foundInAttr) {
                pos = m.end();
                foundInAttr = false;
                continue;
            }
            String url = m.group();
            String link = "<a target=\"_blank\" href=\"" + url + "\">" + url + "</a>";
            value = ((String)value).substring(0, m.start()) + link + ((String)value).substring(m.end());
            pos = m.start() + link.length();
        }
        return value;
    }

    public static String quotEscape(String value) {
        return value.replace("\"", "\\\"");
    }

    public static String truncateHtml(String s, Integer limit) {
        int length = s.length();
        if (length < limit) {
            return s;
        }
        int okIndex = length - 1;
        boolean inClosingTag = false;
        int numOpenTags = 0;
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) == '<') {
                if (s.charAt(i + 1) == '/') {
                    inClosingTag = true;
                } else {
                    ++numOpenTags;
                }
            }
            if (s.charAt(i) == '>') {
                if (s.charAt(i - 1) == '/') {
                    --numOpenTags;
                }
                if (inClosingTag) {
                    --numOpenTags;
                    inClosingTag = false;
                }
            }
            if (numOpenTags != 0 || i < limit) continue;
            okIndex = i;
            break;
        }
        return s.substring(0, okIndex + 1);
    }

    public static String fileNameWithLastModTime(String path) {
        File file = new File("webapps" + path);
        return path + "?version=" + file.lastModified() / 1000L;
    }

    public static String docUrl(String url) {
        String changeId;
        if (url.startsWith("http")) {
            return url;
        }
        InstalledModule m = InstalledModule.get("update");
        String string = changeId = m == null ? "0" : m.getChangeId();
        if (Utils.notBlankString(changeId)) {
            return InstallerChanges.UPDATE_TO_CHANGE_URL + "/" + changeId + "/doc/" + url;
        }
        return "https://bgerp.org/version/" + m.getVersion() + "/doc/" + url;
    }

    public static String actionUrl(String action) throws NotFoundException {
        Actions.Action a = Actions.getById(PermissionNode.actionId(action));
        if (a == null) {
            throw new NotFoundException("Action class not found for action: " + action);
        }
        StringBuffer result = new StringBuffer(100);
        result.append(a.getPath()).append(".do");
        String method = PermissionNode.actionMethod(action);
        if (!"unspecified".equals(method)) {
            result.append("?").append("method").append("=").append(method);
        }
        return result.toString();
    }

    @Deprecated
    public static final String toString(Collection<?> valuesList) {
        log.warndJsp("u:toString", "u.toString");
        return Utils.toString(valuesList);
    }

    @Deprecated
    public static <T extends IdTitle> String objectTitleList(List<T> fullList, Set<Integer> selectedIds) {
        log.warndJsp("u:objectTitleList", "u.getObjectTitles");
        return Utils.getObjectTitles(Utils.getObjectList(fullList, selectedIds));
    }
}

