/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.event.listener;

import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.event.process.ProcessDoActionEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractParameter;
import ru.bgcrm.plugin.bgbilling.proto.model.ParamAddressValue;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@Deprecated
public class ProcessDoActionListener {
    public ProcessDoActionListener() {
        EventProcessor.subscribe(new EventListener<ProcessDoActionEvent>(){

            @Override
            public void notify(ProcessDoActionEvent e, ConnectionSet connectionSet) throws Exception {
                ProcessDoActionListener.this.doCommand(e, connectionSet);
            }
        }, ProcessDoActionEvent.class);
    }

    private void doCommand(ProcessDoActionEvent e, ConnectionSet conSet) throws Exception {
        String prefix = "bgbilling:";
        String command = StringUtils.substringAfter((String)e.getActionName(), (String)"bgbilling:");
        if (Utils.isBlankString(command)) {
            return;
        }
        Process process = e.getProcess();
        if (command.startsWith("getLinkedContractAddressParam")) {
            command = StringUtils.substringAfter((String)command, (String)":");
            String billingId = StringUtils.substringBefore((String)command, (String)":");
            int billingParamId = Utils.parseInt(StringUtils.substringBetween((String)command, (String)":"));
            int crmParamId = Utils.parseInt(StringUtils.substringAfterLast((String)command, (String)":"));
            CommonObjectLink link = Utils.getFirst(new ProcessLinkDAO(conSet.getConnection()).getObjectLinksWithType(process.getId(), "contract:" + billingId));
            if (link == null) {
                return;
            }
            ContractParamDAO paramDAO = new ContractParamDAO(e.getForm().getUser(), billingId);
            ParamAddressValue billingAddress = paramDAO.getAddressParam(link.getLinkObjectId(), billingParamId);
            if (billingAddress == null) {
                return;
            }
            ParameterAddressValue address = billingAddress.toParameterAddressValue(conSet.getConnection());
            if (address.getHouseId() != 0 || Utils.notBlankString(address.getValue())) {
                new ParamValueDAO(conSet.getConnection()).updateParamAddress(process.getId(), crmParamId, 0, address);
            }
        } else if (command.startsWith("getLinkedContractParam")) {
            command = StringUtils.substringAfter((String)command, (String)":");
            String billingId = StringUtils.substringBefore((String)command, (String)":");
            int billingParamId = Utils.parseInt(StringUtils.substringBetween((String)command, (String)":"));
            int crmParamId = Utils.parseInt(StringUtils.substringAfterLast((String)command, (String)":"));
            String paramValue = this.getLinkedContractParamText(e, conSet, process, billingId, billingParamId, false, null);
            this.updateTextParam(conSet, process, crmParamId, paramValue);
        } else if (command.startsWith("linkedContractParamToDescription")) {
            boolean before = command.startsWith("linkedContractParamToDescriptionBefore");
            String[] tokens = (command = StringUtils.substringAfter((String)command, (String)":")).split(":");
            if (tokens.length < 2) {
                throw new BGException("Incorrect tokens: " + command, new Object[0]);
            }
            String billingId = tokens[0];
            int billingParamId = Utils.parseInt(tokens[1]);
            String paramPrefix = tokens.length > 2 ? tokens[2] : null;
            String textForAdd = this.getLinkedContractParamText(e, conSet, process, billingId, billingParamId, true, paramPrefix);
            this.addToDescription(conSet, process, textForAdd, before);
        } else if (command.startsWith("linkedContractCommentToDescription")) {
            boolean before = command.startsWith("linkedContractCommentToDescriptionBefore");
            String[] tokens = (command = StringUtils.substringAfter((String)command, (String)":")).split(":");
            if (tokens.length < 1) {
                throw new BGException("Incorrect tokens: " + command, new Object[0]);
            }
            String billingId = tokens[0];
            String commentPrefix = tokens.length > 1 ? tokens[1] : null;
            CommonObjectLink link = Utils.getFirst(new ProcessLinkDAO(conSet.getConnection()).getObjectLinksWithType(process.getId(), "contract:" + billingId));
            if (link == null) {
                return;
            }
            Contract contract = new ContractDAO(e.getForm().getUser(), billingId).getContractById(link.getLinkObjectId());
            if (contract != null) {
                Object textForAdd = "";
                if (Utils.notBlankString(commentPrefix)) {
                    textForAdd = (String)textForAdd + commentPrefix + ": ";
                }
                textForAdd = (String)textForAdd + contract.getComment();
                this.addToDescription(conSet, process, (String)textForAdd, before);
            }
        } else if (command.startsWith("linkedContractCommentToParam")) {
            String[] tokens = (command = StringUtils.substringAfter((String)command, (String)":")).split(":");
            if (tokens.length < 2) {
                throw new BGException("Incorrect tokens: " + command, new Object[0]);
            }
            String billingId = tokens[0];
            int crmParamId = Utils.parseInt(tokens[1]);
            CommonObjectLink link = Utils.getFirst(new ProcessLinkDAO(conSet.getConnection()).getObjectLinksWithType(process.getId(), "contract:" + billingId));
            if (link == null) {
                return;
            }
            Contract contract = new ContractDAO(e.getForm().getUser(), billingId).getContractById(link.getLinkObjectId());
            if (contract != null) {
                this.updateTextParam(conSet, process, crmParamId, contract.getComment());
            }
        }
    }

    private void updateTextParam(ConnectionSet conSet, Process process, int crmParamId, String paramValue) throws Exception {
        if (Utils.notBlankString(paramValue)) {
            Parameter param = ParameterCache.getParameter(crmParamId);
            if (param == null || !"text".equals(param.getType())) {
                throw new BGException("\u0412 \u043c\u0430\u043a\u0440\u043e\u0441\u0435 getLinkedContractParam \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043b\u0438\u0431\u043e \u043d\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + crmParamId, new Object[0]);
            }
            new ParamValueDAO(conSet.getConnection()).updateParamText(process.getId(), crmParamId, paramValue);
        }
    }

    private String getLinkedContractParamText(ProcessDoActionEvent e, ConnectionSet conSet, Process process, String billingId, int billingParamId, boolean addPrefix, String paramPrefix) {
        CommonObjectLink link = Utils.getFirst(new ProcessLinkDAO(conSet.getConnection()).getObjectLinksWithType(process.getId(), "contract:" + billingId));
        if (link == null) {
            return null;
        }
        Object textForAdd = null;
        ContractParamDAO paramDAO = new ContractParamDAO(e.getForm().getUser(), billingId);
        for (ContractParameter param : paramDAO.getParameterList(link.getLinkObjectId())) {
            if (param.getParamId() != billingParamId) continue;
            if (addPrefix) {
                if (paramPrefix == null) {
                    paramPrefix = param.getTitle();
                }
                textForAdd = paramPrefix + ": " + param.getValue();
                break;
            }
            textForAdd = param.getValue();
            break;
        }
        return textForAdd;
    }

    private void addToDescription(ConnectionSet conSet, Process process, String textForAdd, boolean before) throws Exception {
        Object description = process.getDescription();
        if (Utils.notBlankString(textForAdd) && !((String)description).contains(textForAdd)) {
            if (Utils.notBlankString((String)description)) {
                description = before ? "\n" + (String)description : (String)description + "\n";
            }
            if (before) {
                process.setDescription(textForAdd + (String)description);
            } else {
                process.setDescription((String)description + textForAdd);
            }
            new ProcessDAO(conSet.getConnection()).updateProcess(process);
        }
    }
}

