/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.exception.alarm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import org.bgerp.model.file.FileData;

class AlarmMessage {
    private final Date time = new Date();
    private final String key;
    private final String subject;
    private final String text;
    private final Throwable exception;
    private final List<FileData> attachments;

    AlarmMessage(String key, String subject, String text, Throwable ex, List<FileData> attachments) {
        this.subject = subject;
        this.text = text;
        this.key = key;
        this.exception = ex;
        this.attachments = attachments;
    }

    Date getTime() {
        return this.time;
    }

    String getKey() {
        return this.key;
    }

    String getSubject() {
        return this.subject;
    }

    String getText() {
        StringBuilder result = new StringBuilder(this.text);
        if (this.exception != null) {
            StringWriter sw = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(sw));
            result.append("\n\n");
            result.append(sw.toString());
        }
        return result.toString();
    }

    public List<FileData> getAttachments() {
        return this.attachments;
    }
}

