/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.ConfigDAO;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.model.Config;
import ru.bgcrm.model.Page;
import ru.bgcrm.plugin.Plugin;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/admin/config", pathId=true)
public class ConfigAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/config";

    public ActionForward list(DynActionForm form, ConnectionSet conSet) throws Exception {
        Set<Integer> allowedConfigIds = Utils.toIntegerSet(form.getPermission().get("allowedConfigIds"));
        String filter = LikePattern.SUB.get(form.getParam("filter"));
        Pageable<Config> result = new Pageable<Config>(form);
        result.getPage().setPageIndex(Page.PAGE_INDEX_NO_PAGING);
        List resultList = result.getList();
        new ConfigDAO(conSet.getConnection()).searchGlobalConfigList(result, allowedConfigIds, filter);
        Map<Integer, Config> configMap = resultList.stream().collect(Collectors.toMap(Config::getId, c -> c));
        for (Config config : new ArrayList(resultList)) {
            if (config.getParentId() <= 0) continue;
            Config parent = configMap.get(config.getParentId());
            if (parent == null) {
                this.log.warn("Not found parent config with ID: {}", config.getParentId());
                continue;
            }
            resultList.remove(config);
            parent.addIncluded(config);
        }
        return this.html(conSet, form, "/WEB-INF/jspf/admin/config/list.jsp");
    }

    public ActionForward delete(DynActionForm form, ConnectionSet conSet) throws Exception {
        new ConfigDAO(conSet.getConnection()).deleteGlobalConfig(form.getId());
        return this.json(conSet, form);
    }

    public ActionForward get(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.checkAllowedConfigIds(form);
        Config config = new ConfigDAO(conSet.getConnection()).getGlobalConfig(form.getId());
        if (config != null) {
            form.setResponseData("config", config);
        }
        return this.html(conSet, form, "/WEB-INF/jspf/admin/config/update.jsp");
    }

    public ActionForward update(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.checkAllowedConfigIds(form);
        ConfigDAO configDAO = new ConfigDAO(conSet.getConnection());
        int id = form.getId();
        Config config = new Config();
        if (id > 0) {
            config = configDAO.getGlobalConfig(form.getId());
        }
        if (config == null) {
            throw new NotFoundException("Not found configuration with ID: " + id);
        }
        config.setData(form.getParam("data", ""));
        config.setTitle(form.getParam("title"));
        config.setActive(Utils.parseBoolean(form.getParam("active")));
        boolean activeAllow = form.getPermission().getBoolean("activeAllow", true);
        if (!activeAllow && config.isActive()) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0434\u0435\u043b\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439.", new Object[0]);
        }
        if (Utils.isBlankString(config.getTitle())) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435.", new Object[0]);
        }
        Preferences.processIncludes(configDAO, config.getData(), true);
        this.checkModified(config.getLastModify(), form);
        configDAO.updateGlobalConfig(config);
        if (config.isActive()) {
            configDAO.setActiveGlobalConfig(config.getId());
        }
        EventProcessor.processEvent(new SetupChangedEvent(form), conSet);
        form.setResponseData("config", config);
        return this.json(conSet, form);
    }

    public ActionForward addIncluded(DynActionForm form, ConnectionSet conSet) throws Exception {
        String pluginId = form.getParam("pluginId");
        Config config = new Config();
        config.setParentId(form.getId());
        if (Utils.notBlankString(pluginId)) {
            Plugin plugin = PluginManager.getInstance().getFullPluginMap().get(pluginId);
            config.setData(plugin.getId() + ":enable=1\n");
            config.setTitle("Plugin " + plugin.getTitle());
        } else {
            config.setTitle(this.l.l("\u041d\u043e\u0432\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", new Object[0]));
        }
        ConfigDAO dao = new ConfigDAO(conSet.getConnection());
        this.checkModified(config.getLastModify(), form);
        dao.updateGlobalConfig(config);
        EventProcessor.processEvent(new SetupChangedEvent(form), conSet);
        return this.json(conSet, form);
    }

    public void checkAllowedConfigIds(DynActionForm form) throws BGMessageException {
        Set<Integer> allowedConfigIds = Utils.toIntegerSet(form.getPermission().get("allowedConfigIds"));
        if (CollectionUtils.isNotEmpty(allowedConfigIds) && !allowedConfigIds.contains(form.getId())) {
            throw new BGMessageException("\u0420\u0430\u0431\u043e\u0442\u0430 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0435\u0439 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430", new Object[0]);
        }
    }
}

