/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.param.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import ru.bgcrm.util.RangeChecker;
import ru.bgcrm.util.Utils;

public class ListParamConfig
extends Config {
    private static final String ALLOW_COMMENT_VALUES = "allowCommentValues";
    private static final String NEED_COMMENT_VALUES = "needCommentValues";
    private Map<Integer, String> allowCommentValues = Collections.emptyMap();
    private Map<Integer, String> needCommentValues = Collections.emptyMap();
    private Map<Integer, String> commentValues = Collections.emptyMap();

    public ListParamConfig(ConfigMap setup) {
        super(null);
        String values = setup.get(ALLOW_COMMENT_VALUES);
        if (Utils.notBlankString(values)) {
            this.allowCommentValues = new RangeCheckerMapWrapper(new RangeChecker(values));
        }
        if (Utils.notBlankString(values = setup.get(NEED_COMMENT_VALUES))) {
            this.needCommentValues = new RangeCheckerMapWrapper(new RangeChecker(values));
        }
        if (this.allowCommentValues != null || this.needCommentValues != null) {
            this.commentValues = new HashMap<Integer, String>(){

                @Override
                public String get(Object key) {
                    String result = null;
                    if (ListParamConfig.this.allowCommentValues != null) {
                        result = ListParamConfig.this.allowCommentValues.get(key);
                    }
                    if (result == null && ListParamConfig.this.needCommentValues != null) {
                        result = ListParamConfig.this.needCommentValues.get(key);
                    }
                    return result;
                }
            };
        }
    }

    public Map<Integer, String> getAllowCommentValues() {
        return this.allowCommentValues;
    }

    public Map<Integer, String> getNeedCommentValues() {
        return this.needCommentValues;
    }

    public Map<Integer, String> getCommentValues() {
        return this.commentValues;
    }

    private static class RangeCheckerMapWrapper
    extends HashMap<Integer, String> {
        private RangeChecker checker;

        private RangeCheckerMapWrapper(RangeChecker checker) {
            this.checker = checker;
        }

        @Override
        public String get(Object key) {
            if (key instanceof Integer) {
                return this.checker.check(((Integer)key).longValue()) ? "1" : null;
            }
            if (key instanceof Long) {
                return this.checker.check((Long)key) ? "1" : null;
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }
    }
}

