/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.text;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bgcrm.util.Utils;

public class PatternFormatter {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{([\\w:]+)\\}");

    public static String processPattern(String pattern, Function<String, String> processor) {
        StringBuilder result = new StringBuilder(pattern.length());
        int pos = 0;
        Matcher m = VAR_PATTERN.matcher(pattern);
        while (pos < pattern.length() && m.find(pos)) {
            int start = m.start();
            int brace = pattern.indexOf(40, pos, start);
            boolean braces = pos <= brace;
            result.append(pattern.substring(pos, braces ? brace : start));
            String name = m.group(1);
            String value = processor.apply(name);
            boolean valueExists = Utils.notBlankString(value);
            if (valueExists) {
                if (braces) {
                    result.append(pattern.substring(brace + 1, start));
                }
                result.append(value);
            }
            int end = m.end() - 1;
            if (braces) {
                brace = pattern.indexOf(41, end);
                if (end < brace) {
                    pos = brace + 1;
                    if (!valueExists) continue;
                    result.append(pattern.substring(end + 1, brace));
                    continue;
                }
                pos = end + 1;
                continue;
            }
            pos = end + 1;
        }
        if (pos < pattern.length()) {
            result.append(pattern.substring(pos));
        }
        return result.toString();
    }

    public static String processPattern(String pattern, Map<String, String> values) {
        return PatternFormatter.processPattern(pattern, (String key) -> (String)values.get(key));
    }
}

