/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.dao.expression.Expression;
import org.bgerp.dao.expression.ProcessLinkExpressionObject;
import org.bgerp.dao.expression.ProcessParamExpressionObject;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.callboard.model.work.ShiftData;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.util.Utils;

public class WorkType
extends IdTitle {
    public static final int MODE_TIME_ON_START = 0;
    public static final int MODE_TIME_ON_STEP = 1;
    private boolean isNonWorkHours;
    private int category;
    private String comment = "";
    private String color;
    private List<String> shortcutList;
    private int timeSetStep;
    private int timeSetMode;
    private String ruleConfig;
    private List<Rule> ruleExpressionList;

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isNonWorkHours() {
        return this.isNonWorkHours;
    }

    public void setNonWorkHours(boolean isNonWorkHours) {
        this.isNonWorkHours = isNonWorkHours;
    }

    public boolean getIsNonWorkHours() {
        return this.isNonWorkHours;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public List<String> getShortcutList() {
        return this.shortcutList;
    }

    public void setShortcutList(List<String> shortcutList) {
        this.shortcutList = shortcutList;
    }

    public int getTimeSetStep() {
        return this.timeSetStep;
    }

    public void setTimeSetStep(int step) {
        this.timeSetStep = step;
    }

    public int getTimeSetMode() {
        return this.timeSetMode;
    }

    public void setTimeSetMode(int distributeMode) {
        this.timeSetMode = distributeMode;
    }

    public String getConfig() {
        StringBuilder result = new StringBuilder();
        Utils.addSetupPair(result, "", "color", String.valueOf(this.color));
        Utils.addSetupPair(result, "shortcuts", "", Utils.toString(this.shortcutList));
        Utils.addSetupPair(result, "timeSetStep", "", String.valueOf(this.timeSetStep));
        Utils.addSetupPair(result, "timeSetMode", "", String.valueOf(this.timeSetMode));
        return result.toString();
    }

    public void setConfigMap(ConfigMap configMap) {
        this.color = configMap.get("color", "#000000");
        this.shortcutList = Utils.toList(configMap.get("shortcuts", ""));
        this.timeSetStep = configMap.getInt("timeSetStep", configMap.getInt("step", 0));
        this.timeSetMode = configMap.getInt("timeSetMode", 0);
    }

    public String getRuleConfig() {
        return this.ruleConfig;
    }

    public void setRuleConfig(String ruleConfig) {
        this.ruleConfig = ruleConfig;
    }

    public List<Rule> getRuleExpresionList() {
        if (this.ruleExpressionList == null) {
            this.ruleExpressionList = new ArrayList<Rule>();
            for (ConfigMap pm : new Preferences(this.ruleConfig).subIndexed("rule.").values()) {
                this.ruleExpressionList.add(new Rule(pm));
            }
        }
        return this.ruleExpressionList;
    }

    public int getProcessExecuteTime(Connection con, ShiftData shiftData, Process process) {
        int result = -1;
        HashMap<String, Object> context = new HashMap<String, Object>(4);
        context.put("process", process);
        new ProcessParamExpressionObject(con, process.getId()).toContext(context);
        new ProcessLinkExpressionObject(con, process.getId()).toContext(context);
        context.put("shift", shiftData);
        for (Rule rule : this.getRuleExpresionList()) {
            if (!new Expression(context).executeCheck(rule.checkExpression)) continue;
            result = rule.duration;
            break;
        }
        return result;
    }

    public int getSlotCount(int minuteFrom, int minuteTo) {
        if (this.timeSetStep <= 0) {
            return 1;
        }
        return (minuteTo - minuteFrom) / this.timeSetStep;
    }

    private static class Rule {
        private String checkExpression;
        private int duration;

        private Rule(ConfigMap config) {
            this.checkExpression = config.get("checkExpression", "");
            this.duration = config.getInt("duration", 0);
        }
    }
}

