/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.taglibs.standard.functions.Functions;
import org.bgerp.app.servlet.jsp.UtilFunction;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.iface.Id;
import org.bgerp.model.base.iface.Title;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;

@Dynamic
public class Utils {
    private static final Log log = Log.getLog();
    public static final String DEFAULT_DELIM = ", ";
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] HEX_LOWERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String TMP_DIR = Utils.getSystemProperty("tmpdir", "tmp");

    public static int parseInt(String str) {
        return Utils.parseInt(str, 0);
    }

    public static int parseInt(String str, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static long parseLong(String str) {
        return Utils.parseLong(str, 0L);
    }

    public static long parseLong(String str, long defaultValue) {
        long value = defaultValue;
        try {
            value = Long.parseLong(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static BigDecimal parseBigDecimal(Object obj, BigDecimal defaultValue) {
        try {
            return new BigDecimal(String.valueOf(obj));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static BigDecimal parseBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        return Utils.parseBigDecimal(obj, BigDecimal.ZERO);
    }

    public static boolean parseBoolean(String str) {
        return Utils.parseBoolean(str, false);
    }

    public static boolean isStringNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Boolean parseBoolean(String str, Boolean defaultValue) {
        Boolean result = defaultValue;
        try {
            String v = str.toUpperCase();
            if ("0".equals(v) || "FALSE".equals(v) || "NO".equals(v)) {
                result = false;
            } else if ("1".equals(v) || "TRUE".equals(v) || "YES".equals(v) || "ON".equals(v)) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static final String booleanToStringInt(boolean value) {
        return value ? "1" : "0";
    }

    public static final <T> T maskNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static final String maskNull(String value) {
        return value == null ? "" : value;
    }

    public static final BigDecimal maskNullDecimal(BigDecimal value) {
        return value != null ? value : BigDecimal.ZERO;
    }

    public static final <T, C extends Collection<T>> C emptyToNull(C value) {
        if (value == null || value.size() == 0) {
            return null;
        }
        return value;
    }

    public static final String maskEmpty(String value, String defaultValue) {
        return Utils.isEmptyString(value) ? defaultValue : value;
    }

    public static final boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }

    public static final boolean isBlankString(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static final boolean notEmptyString(String value) {
        return value != null && value.length() > 0;
    }

    public static final boolean notBlankString(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static final boolean notBlankStrings(String ... value) {
        if (value == null) {
            return false;
        }
        for (String val : value) {
            if (!Utils.isBlankString(val)) continue;
            return false;
        }
        return true;
    }

    public static final int countLines(String value) {
        if (value == null) {
            return 0;
        }
        int count = 0;
        int index = value.indexOf(10);
        while (index != -1) {
            ++count;
            index = value.indexOf(10, index + 1);
        }
        return count;
    }

    public static final boolean isPositive(Integer value) {
        return value > 0;
    }

    public static final boolean isValidEmail(String value) {
        if (Utils.isBlankString(value)) {
            return false;
        }
        try {
            new InternetAddress(value).validate();
            return true;
        }
        catch (AddressException ex) {
            return false;
        }
    }

    public static final String toString(Collection<?> valuesList) {
        return Utils.toString(valuesList, "", DEFAULT_DELIM);
    }

    public static final String toString(Collection<?> valuesList, String emptyValue, String delim) {
        if (valuesList != null && valuesList.size() != 0) {
            StringBuilder result = new StringBuilder(valuesList.size() * 5);
            for (Object next : valuesList) {
                Utils.addObjectToList(result, next, delim);
            }
            return result.toString();
        }
        return emptyValue;
    }

    private static void addObjectToList(StringBuilder result, Object next, String delim) {
        if (result.length() != 0) {
            result.append(delim);
        }
        if (next instanceof Integer) {
            result.append((Integer)next);
        } else {
            result.append(next);
        }
    }

    public static final List<Integer> toIntegerList(String valuesStr) {
        return Utils.toIntegerList(valuesStr, ",;");
    }

    public static final List<Integer> toIntegerList(String valuesStr, String delims) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (Utils.notBlankString(valuesStr)) {
            StringTokenizer st = new StringTokenizer(valuesStr.trim(), delims);
            while (st.hasMoreTokens()) {
                try {
                    result.add(Integer.valueOf(st.nextToken().trim()));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static final Set<Integer> toIntegerSet(String valuesStr) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        if (Utils.notBlankString(valuesStr)) {
            StringTokenizer st = new StringTokenizer(valuesStr.trim(), ",;");
            while (st.hasMoreTokens()) {
                try {
                    result.add(Integer.valueOf(st.nextToken().trim()));
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static final Set<String> toSet(String valuesStr, String delims) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (Utils.notBlankString(valuesStr)) {
            StringTokenizer st = new StringTokenizer(valuesStr.trim(), delims);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
        }
        return result;
    }

    public static final Set<String> toSet(String valuesStr) {
        HashSet<String> result = new HashSet<String>();
        if (Utils.notBlankString(valuesStr)) {
            StringTokenizer st = new StringTokenizer(valuesStr.trim(), ",;");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public static final List<String> toList(String valuesStr) {
        return Utils.toList(valuesStr, ",;");
    }

    public static final List<String> toList(String value, String delims) {
        ArrayList<String> result = new ArrayList<String>();
        if (Utils.notBlankString(value)) {
            StringTokenizer st = new StringTokenizer(value.trim(), delims);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public static final String toText(List<String> config, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object configLine : config.toArray()) {
            sb.append(configLine).append(separator);
        }
        return sb.toString();
    }

    public static final <T extends IdTitle> List<Integer> getObjectIdsList(Collection<T> list) {
        ArrayList<Integer> result = new ArrayList<Integer>(list.size());
        for (IdTitle object : list) {
            result.add(object.getId());
        }
        return result;
    }

    public static final <T extends IdTitle> Set<Integer> getObjectIdsSet(Collection<T> list) {
        HashSet<Integer> result = new HashSet<Integer>(list.size());
        for (IdTitle object : list) {
            result.add(object.getId());
        }
        return result;
    }

    public static final <T extends Id<Integer>> String getObjectIds(Collection<T> values) {
        return Utils.getObjectIds(values, null);
    }

    public static final <T extends Id<Integer>> String getObjectIds(Collection<T> values, String startValues) {
        return Utils.getObjectIds(values, startValues, DEFAULT_DELIM);
    }

    public static <T extends Id<Integer>> String getObjectIds(Collection<T> values, String startValues, String delim) {
        StringBuilder result = new StringBuilder();
        if (Utils.notEmptyString(startValues)) {
            result.append(startValues);
        }
        if (values != null) {
            for (Id object : values) {
                if (result.length() != 0) {
                    result.append(delim);
                }
                result.append(object.getId());
            }
        }
        return result.toString();
    }

    public static final <T extends Title> String getObjectTitles(Collection<T> list) {
        return list == null ? "" : list.stream().map(Title::getTitle).collect(Collectors.joining(DEFAULT_DELIM));
    }

    public static <T extends IdTitle> String getObjectTitles(List<T> fullList, Set<Integer> selectedIds) {
        return Utils.getObjectTitles(Utils.getObjectList(fullList, selectedIds));
    }

    public static final <T extends IdTitle> String getObjectTitles(Map<Integer, T> fullMap, List<Integer> selectedIds) {
        return Utils.getObjectTitles(Utils.getObjectList(fullMap, selectedIds));
    }

    public static final <T extends IdTitle> List<T> getObjectList(List<T> fullList, Collection<Integer> selectedIds) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        for (IdTitle object : fullList) {
            if (selectedIds == null || !selectedIds.contains(object.getId())) continue;
            result.add(object);
        }
        return result;
    }

    public static final <T extends IdTitle> List<T> getObjectList(Map<Integer, T> fullMap, List<Integer> selectedIds) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        for (int id : selectedIds) {
            IdTitle object = (IdTitle)fullMap.get(id);
            if (object == null) continue;
            result.add(object);
        }
        return result;
    }

    public static final List<IdTitle> parseIdTitleList(String value) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        StringTokenizer st = new StringTokenizer(value, ";,");
        while (st.hasMoreTokens()) {
            String[] pair = st.nextToken().split(":");
            if (pair.length != 2) continue;
            result.add(new IdTitle(Utils.parseInt(pair[0]), pair[1]));
        }
        return result;
    }

    public static final List<IdTitle> parseIdTitleList(String value, String noPairValue) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        if (value == null) {
            return result;
        }
        if (value.contains(":")) {
            try {
                StringTokenizer st = new StringTokenizer(value, ";,");
                while (st.hasMoreTokens()) {
                    String nextToken = st.nextToken();
                    if (nextToken.indexOf(":") > 0) {
                        String[] pair = nextToken.split(":");
                        result.add(new IdTitle(Utils.parseInt(pair[0].replaceAll("[^\\d]", "")), pair[1].replaceAll("[^\\d]", "")));
                        continue;
                    }
                    result.add(new IdTitle(Utils.parseInt(nextToken.replaceAll("[^\\d]", "")), noPairValue));
                }
            }
            catch (Exception e) {
                return result;
            }
        } else {
            Set<Integer> groupIdSet = Utils.toIntegerSet(value);
            for (Integer groupId : groupIdSet) {
                result.add(new IdTitle(groupId, noPairValue));
            }
        }
        return result;
    }

    public static final void addSetupPair(StringBuilder data, String prefix, String param, String value) {
        data.append(prefix);
        data.append(param);
        data.append("=");
        data.append(value);
        data.append("\n");
    }

    public static final void addCommaSeparated(StringBuilder result, String value) {
        Utils.addSeparated(result, DEFAULT_DELIM, value);
    }

    public static final void addSeparated(StringBuilder result, String separator, String value) {
        if (result.length() != 0) {
            result.append(separator);
        }
        result.append(value);
    }

    public static String getDigest(String value) {
        return Utils.getDigest(value, StandardCharsets.UTF_8.name());
    }

    public static String getDigest(String value, String charset) {
        try {
            return Utils.getDigest(value.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e);
            return null;
        }
    }

    public static String getDigest(byte[] value) {
        StringBuffer passwdDigest = new StringBuffer(32);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(value);
            byte[] digestBytes = digest.digest();
            for (int i = 0; i < digestBytes.length; ++i) {
                passwdDigest.append(HEX[(digestBytes[i] & 0xF0) >> 4]);
                passwdDigest.append(HEX[digestBytes[i] & 0xF]);
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
        return passwdDigest.length() == 0 ? null : passwdDigest.toString();
    }

    public static String getTmpDir() {
        return TMP_DIR;
    }

    public static final File createDirectoryIfNoExistInWorkDir(String dirName) {
        File dir = new File(dirName);
        if (!dir.exists()) {
            File logFile = new File("log");
            dir = new File(logFile.getAbsolutePath() + "/../" + dirName);
            dir.mkdir();
        }
        return dir;
    }

    public static final String substringAfter(String value, String token, int num) {
        String result = "";
        int lastFindPos = 0;
        int findPos = 0;
        while ((findPos = value.indexOf(token, lastFindPos + 1)) >= 0 && num > 0) {
            --num;
            lastFindPos = findPos;
        }
        if (num == 0) {
            result = value.substring(lastFindPos + 1);
        }
        return result;
    }

    public static final String generateSecret() {
        byte[] random = new byte[32];
        new Random().nextBytes(random);
        return Utils.getDigest(random);
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (collection != null && collection.size() > 0) {
            return collection.iterator().next();
        }
        return null;
    }

    public static String escapeXml(String value) {
        if (Utils.isBlankString(value)) {
            return value;
        }
        return Functions.escapeXml((String)value);
    }

    public static String htmlEncode(String value) {
        return UtilFunction.htmlEncode(value);
    }

    public static int getOpenId(String url) {
        if (Utils.isBlankString(url)) {
            return 0;
        }
        int posFrom = url.lastIndexOf(47);
        if (posFrom == -1) {
            return 0;
        }
        int posTo = url.indexOf(63, posFrom);
        if (posTo == -1) {
            posTo = url.indexOf(35, posFrom);
        }
        if (posTo == -1) {
            posTo = url.length();
        }
        return Utils.parseInt(url.substring(posFrom + 1, posTo));
    }

    public static void setFileNameHeaders(HttpServletResponse response, String fileName) {
        try {
            response.setContentType(URLConnection.guessContentTypeFromName(fileName));
            response.setHeader("Content-Disposition", "attachment;filename=\"" + new String(fileName.getBytes("UTF-8"), "ISO-8859-1") + "\"");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e);
        }
    }

    public static void errorAndExit(int code, String message) {
        System.err.println(message);
        System.err.flush();
        System.exit(code);
    }

    @Deprecated
    public static Object newInstance(String className, Object ... args) throws Exception {
        log.warndMethod("u.newInstance", "u:newInstance0");
        return UtilFunction.newInstance(className, args);
    }

    public static boolean hasClass(Object o, String ... names) {
        for (String name : names) {
            if (!o.getClass().getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String getSystemProperty(String key, String defaultValue) {
        if (key.startsWith("bgerp")) {
            throw new IllegalArgumentException("Do not use 'bgerp' prefix for a key");
        }
        return System.getProperty("bgerp." + key, defaultValue);
    }

    public static String format(BigDecimal value) {
        if (value == null) {
            return "";
        }
        return value.stripTrailingZeros().toPlainString();
    }

    static {
        File tmpDir = new File(TMP_DIR);
        if (!tmpDir.exists()) {
            log.info("Creating tmp dir: {}", TMP_DIR);
            tmpDir.mkdir();
        }
    }
}

