/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.AddressDAO;
import ru.bgcrm.model.param.address.AddressCity;
import ru.bgcrm.model.param.address.AddressCountry;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.model.param.address.AddressItem;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/directory/address")
public class DirectoryAddressAction
extends BaseAction {
    private static final String PATH_JSP_ADDRESS = "/WEB-INF/jspf/user/directory/address/address.jsp";

    @Override
    public ActionForward unspecified(DynActionForm form, Connection con) throws Exception {
        return this.address(form, con);
    }

    public ActionForward address(DynActionForm form, Connection con) throws Exception {
        AddressCountry addressCountry;
        ConfigMap permission = form.getPermission();
        AddressDAO addressDAO = new AddressDAO(con);
        String searchMode = form.getParam("searchMode");
        String selectTab = form.getParam("selectTab");
        if (Utils.isBlankString(selectTab)) {
            selectTab = "street";
            form.setParam("selectTab", "street");
        }
        int addressCountryId = Utils.parseInt(form.getParam("addressCountryId"));
        int addressCityId = Utils.parseInt(form.getParam("addressCityId"));
        int addressStreetId = Utils.parseInt(form.getParam("addressItemId"));
        Set<Integer> allowedCityIds = Utils.toIntegerSet(permission.get("cityIds"));
        if (addressStreetId > 0) {
            AddressItem addressStreet = addressDAO.getAddressStreet(addressStreetId, true, true);
            if (addressStreet != null) {
                AddressCity addressCity = addressStreet.getAddressCity();
                AddressCountry addressCountry2 = addressCity.getAddressCountry();
                form.setParam("addressItemTitle", addressStreet.getTitle());
                form.setParam("addressItemId", String.valueOf(addressStreet.getId()));
                form.setParam("addressCityTitle", addressCity.getTitle());
                form.setParam("addressCityId", String.valueOf(addressCity.getId()));
                form.setParam("addressCountryTitle", addressCountry2.getTitle());
                form.setParam("addressCountryId", String.valueOf(addressCountry2.getId()));
            }
        } else if (addressCityId > 0) {
            AddressCity addressCity = addressDAO.getAddressCity(addressCityId, true);
            if (addressCity != null) {
                AddressCountry addressCountry3 = addressCity.getAddressCountry();
                form.setParam("addressCityTitle", addressCity.getTitle());
                form.setParam("addressCityId", String.valueOf(addressCity.getId()));
                form.setParam("addressCountryTitle", addressCountry3.getTitle());
                form.setParam("addressCountryId", String.valueOf(addressCountry3.getId()));
            }
        } else if (addressCountryId > 0 && (addressCountry = addressDAO.getAddressCountry(addressCountryId)) != null) {
            form.setParam("addressCountryTitle", addressCountry.getTitle());
            form.setParam("addressCountryId", String.valueOf(addressCountry.getId()));
        }
        if (searchMode == null) {
            searchMode = "country";
        }
        form.setParam("searchMode", searchMode);
        if ("house".equals(searchMode)) {
            String addressHouse = form.getParam("addressHouse");
            searchResult = new Pageable<AddressHouse>(form);
            addressDAO.searchAddressHouseList(searchResult, addressStreetId, addressHouse, true, true, true, true);
        } else if ("item".equals(searchMode)) {
            if ("area".equals(selectTab)) {
                addressItemTitle = form.getParam("addressItemTitle");
                searchResult = new Pageable(form);
                addressDAO.searchAddressAreaList(searchResult, addressCityId, Utils.isEmptyString(addressItemTitle) ? null : List.of(LikePattern.SUB.get(addressItemTitle)), true, true);
            } else if ("quarter".equals(selectTab)) {
                addressItemTitle = form.getParam("addressItemTitle");
                searchResult = new Pageable(form);
                addressDAO.searchAddressQuarterList(searchResult, addressCityId, Utils.isEmptyString(addressItemTitle) ? null : List.of(LikePattern.SUB.get(addressItemTitle)), true, true);
            } else if ("street".equals(selectTab)) {
                addressItemTitle = form.getParam("addressItemTitle");
                searchResult = new Pageable(form);
                addressDAO.searchAddressStreetList(searchResult, Collections.singleton(addressCityId), Utils.isEmptyString(addressItemTitle) ? null : List.of(LikePattern.SUB.get(addressItemTitle)), true, true);
            }
        } else if ("city".equals(searchMode)) {
            String addressCityTitle = form.getParam("addressCityTitle");
            searchResult = new Pageable(form);
            addressDAO.searchAddressCityList(searchResult, addressCountryId, LikePattern.SUB.get(addressCityTitle), true, allowedCityIds);
        } else if ("country".equals(searchMode)) {
            String addressCountryTitle = form.getParam("addressCountryTitle");
            searchResult = new Pageable(form);
            addressDAO.searchAddressCountryList(searchResult, LikePattern.SUB.get(addressCountryTitle));
        }
        return this.html(con, form, PATH_JSP_ADDRESS);
    }

    public ActionForward addressGet(DynActionForm form, Connection con) throws Exception {
        AddressDAO addressDAO = new AddressDAO(con);
        int addressHouseId = Utils.parseInt(form.getParam("addressHouseId"), -1);
        int addressStreetId = Utils.parseInt(form.getParam("addressItemId"), -1);
        int addressCityId = Utils.parseInt(form.getParam("addressCityId"), -1);
        int addressCountryId = Utils.parseInt(form.getParam("addressCountryId"), -1);
        if (addressHouseId >= 0) {
            AddressHouse addressHouse = addressDAO.getAddressHouse(addressHouseId, true, true, true);
            if (addressHouse == null) {
                addressHouse = new AddressHouse();
                addressHouse.setStreetId(addressStreetId);
                addressHouse.setAddressStreet(addressDAO.getAddressStreet(addressStreetId, true, true));
            }
            if (Utils.isBlankString(form.getParam("addressCountryTitle"))) {
                form.setParam("addressCountryTitle", addressHouse.getAddressStreet().getAddressCity().getAddressCountry().getTitle());
                form.setParam("addressCityTitle", addressHouse.getAddressStreet().getAddressCity().getTitle());
            }
            form.setResponseData("house", addressHouse);
            form.setParam("config", this.getConfigString(addressHouse.getConfig()));
            int cityId = addressHouse.getAddressStreet().getCityId();
            HttpServletRequest request = form.getHttpRequest();
            Pageable<AddressItem> searchResultStreet = new Pageable<AddressItem>();
            addressDAO.searchAddressStreetList(searchResultStreet, cityId);
            request.setAttribute("parameterAddressStreetList", searchResultStreet.getList());
            Pageable<AddressItem> searchResultArea = new Pageable<AddressItem>();
            addressDAO.searchAddressAreaList(searchResultArea, cityId);
            request.setAttribute("parameterAddressAreaList", searchResultArea.getList());
            Pageable<AddressItem> searchResultQuarter = new Pageable<AddressItem>();
            addressDAO.searchAddressQuarterList(searchResultQuarter, cityId);
            request.setAttribute("parameterAddressQuarterList", searchResultQuarter.getList());
        } else if (!this.getAddressItem(form, con)) {
            if (addressCityId >= 0) {
                AddressCity addressCity = addressDAO.getAddressCity(addressCityId, true);
                if (addressCity == null) {
                    addressCity = new AddressCity();
                    addressCity.setCountryId(addressCountryId);
                    addressCity.setAddressCountry(addressDAO.getAddressCountry(addressCountryId));
                }
                form.setParam("title", addressCity.getTitle());
                form.setParam("config", this.getConfigString(addressCity.getConfig()));
                form.setResponseData("city", addressCity);
            } else if (addressCountryId >= 0) {
                AddressCountry addressCountry = addressDAO.getAddressCountry(addressCountryId);
                if (addressCountry == null) {
                    addressCountry = new AddressCountry();
                }
                form.setParam("title", addressCountry.getTitle());
                form.setParam("config", this.getConfigString(addressCountry.getConfig()));
                form.setResponseData("country", addressCountry);
            }
        }
        return this.html(con, form, PATH_JSP_ADDRESS);
    }

    private boolean getAddressItem(DynActionForm form, Connection con) throws Exception {
        AddressDAO addressDAO = new AddressDAO(con);
        int addressItemId = Utils.parseInt(form.getParam("addressItemId"), -1);
        int addressCityId = Utils.parseInt(form.getParam("addressCityId"), -1);
        String itemType = form.getParam("selectTab");
        if (addressItemId >= 0) {
            AddressItem addressItem = null;
            if (itemType != null) {
                if ("street".equals(itemType)) {
                    addressItem = addressDAO.getAddressStreet(addressItemId, true, true);
                } else if ("area".equals(itemType)) {
                    addressItem = addressDAO.getAddressArea(addressItemId, true, true);
                } else if ("quarter".equals(itemType)) {
                    addressItem = addressDAO.getAddressQuarter(addressItemId, true, true);
                }
            }
            if (addressItem == null) {
                addressItem = new AddressItem();
                addressItem.setCityId(addressCityId);
                addressItem.setAddressCity(addressDAO.getAddressCity(addressCityId, true));
            }
            form.setParam("title", addressItem.getTitle());
            form.setParam("config", this.getConfigString(addressItem.getConfig()));
            form.setResponseData(itemType.toLowerCase(), addressItem);
            return true;
        }
        return false;
    }

    public ActionForward addressUpdate(DynActionForm form, Connection con) throws Exception {
        AddressDAO addressDAO = new AddressDAO(con);
        int addressHouseId = Utils.parseInt(form.getParam("addressHouseId"), -1);
        int addressStreetId = Utils.parseInt(form.getParam("addressItemId"), -1);
        int addressCityId = Utils.parseInt(form.getParam("addressCityId"), -1);
        int addressCountryId = Utils.parseInt(form.getParam("addressCountryId"), -1);
        ConfigMap permission = form.getPermission();
        Set<Integer> allowedCityIds = Utils.toIntegerSet(permission.get("cityIds"));
        if (addressHouseId >= 0) {
            AddressHouse addressHouse = new AddressHouse();
            addressHouse.setId(addressHouseId);
            addressHouse.setStreetId(addressStreetId);
            addressHouse.setAddressStreet(addressDAO.getAddressStreet(addressStreetId, true, true));
            this.checkCityAllow(allowedCityIds, addressHouse.getAddressStreet().getCityId());
            addressHouse.setAreaId(Utils.parseInt(form.getParam("addressAreaId")));
            addressHouse.setQuarterId(Utils.parseInt(form.getParam("addressQuarterId")));
            addressHouse.setStreetId(addressStreetId);
            addressHouse.setHouseAndFrac(form.getParam("house"));
            addressHouse.setComment(form.getParam("comment", ""));
            addressHouse.setConfig(form.getParam("config", ""));
            String postIndex = form.getParam("postIndex", "");
            addressHouse.setPostIndex(postIndex);
            addressDAO.updateAddressHouse(addressHouse);
            if (addressHouseId > 0) {
                new ParamValueDAO(con).updateParamsAddressOnHouseUpdate(addressHouseId);
            }
        } else if (!this.updateAddressItem(form, con)) {
            if (addressCityId >= 0) {
                AddressCity addressCity = new AddressCity();
                addressCity.setId(addressCityId);
                addressCity.setCountryId(addressCountryId);
                addressCity.setAddressCountry(addressDAO.getAddressCountry(addressCountryId));
                this.checkCityRestriction(allowedCityIds);
                addressCity.setTitle(form.getParam("title"));
                addressDAO.updateAddressCity(addressCity);
            } else if (addressCountryId >= 0) {
                AddressCountry addressCountry = new AddressCountry();
                addressCountry.setId(addressCountryId);
                this.checkCityRestriction(allowedCityIds);
                addressCountry.setTitle(form.getParam("title"));
                addressDAO.updateAddressCountry(addressCountry);
            }
        }
        return this.json(con, form);
    }

    private boolean updateAddressItem(DynActionForm form, Connection con) throws Exception {
        AddressDAO addressDAO = new AddressDAO(con);
        int addressCityId = Utils.parseInt(form.getParam("addressCityId"), -1);
        int addressItemId = Utils.parseInt(form.getParam("addressItemId"), -1);
        String itemType = form.getParam("selectTab");
        if (addressItemId >= 0) {
            ConfigMap permission = form.getPermission();
            Set<Integer> allowedCityIds = Utils.toIntegerSet(permission.get("cityIds"));
            this.checkCityAllow(allowedCityIds, addressCityId);
            AddressItem addressItem = new AddressItem();
            addressItem.setId(addressItemId);
            addressItem.setCityId(addressCityId);
            addressItem.setAddressCity(addressDAO.getAddressCity(addressCityId, true));
            addressItem.setTitle(form.getParam("title"));
            if (itemType != null) {
                if ("street".equals(itemType)) {
                    addressDAO.updateAddressStreet(addressItem);
                } else if ("area".equals(itemType)) {
                    addressDAO.updateAddressArea(addressItem);
                } else if ("quarter".equals(itemType)) {
                    addressDAO.updateAddressQuarter(addressItem);
                }
            }
            return true;
        }
        return false;
    }

    public ActionForward addressDelete(DynActionForm form, Connection con) throws Exception {
        ConfigMap permission = form.getPermission();
        Set<Integer> allowedCityIds = Utils.toIntegerSet(permission.get("cityIds"));
        AddressDAO addressDAO = new AddressDAO(con);
        int addressHouseId = Utils.parseInt(form.getParam("addressHouseId"), -1);
        int addressCityId = Utils.parseInt(form.getParam("addressCityId"), -1);
        int addressCountryId = Utils.parseInt(form.getParam("addressCountryId"), -1);
        if (addressHouseId >= 0) {
            AddressHouse addressHouse = addressDAO.getAddressHouse(addressHouseId, true, true, true);
            this.checkCityAllow(allowedCityIds, addressHouse.getAddressStreet().getCityId());
            addressDAO.deleteAddressHouse(addressHouseId);
        } else if (!this.deleteAddressItem(form, con)) {
            if (addressCityId >= 0) {
                AddressCity addressCity = new AddressCity();
                addressCity.setId(addressCityId);
                addressCity.setCountryId(addressCountryId);
                addressCity.setAddressCountry(addressDAO.getAddressCountry(addressCountryId));
                this.checkCityRestriction(allowedCityIds);
                addressDAO.deleteAddressCity(addressCityId);
            } else if (addressCountryId >= 0) {
                AddressCountry addressCountry = new AddressCountry();
                addressCountry.setId(addressCountryId);
                this.checkCityRestriction(allowedCityIds);
                addressDAO.deleteAddressCountry(addressCountryId);
            }
        }
        return this.json(con, form);
    }

    private boolean deleteAddressItem(DynActionForm form, Connection con) throws Exception {
        AddressDAO addressDAO = new AddressDAO(con);
        int addressItemId = Utils.parseInt(form.getParam("addressItemId"), -1);
        String itemType = form.getParam("selectTab");
        if (addressItemId >= 0) {
            ConfigMap permission = form.getPermission();
            Set<Integer> allowedCityIds = Utils.toIntegerSet(permission.get("cityIds"));
            if ("street".equals(itemType)) {
                AddressItem item = addressDAO.getAddressStreet(addressItemId, false, true);
                this.checkCityAllow(allowedCityIds, item.getCityId());
                addressDAO.deleteAddressStreet(addressItemId);
            } else if ("area".equals(itemType)) {
                AddressItem item = addressDAO.getAddressArea(addressItemId, false, true);
                this.checkCityAllow(allowedCityIds, item.getCityId());
                addressDAO.deleteAddressArea(addressItemId);
            } else if ("quarter".equals(itemType)) {
                AddressItem item = addressDAO.getAddressQuarter(addressItemId, false, true);
                this.checkCityAllow(allowedCityIds, item.getCityId());
                addressDAO.deleteAddressQuarter(addressItemId);
            }
            return true;
        }
        return false;
    }

    private void checkCityRestriction(Set<Integer> allowedCityIds) throws BGMessageException {
        if (allowedCityIds.size() != 0) {
            throw new BGMessageException("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0433\u043e\u0440\u043e\u0434\u0430\u043c.", new Object[0]);
        }
    }

    private void checkCityAllow(Set<Integer> allowedCityIds, int cityId) throws BGMessageException {
        if (allowedCityIds.size() != 0 && !allowedCityIds.contains(cityId)) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0433\u043e\u0440\u043e\u0434\u0430.", new Object[0]);
        }
    }

    protected String getConfigString(Map<String, String> configMap) {
        StringBuilder config = new StringBuilder();
        if (configMap != null) {
            for (String key : configMap.keySet()) {
                config.append(key);
                config.append("=");
                config.append(configMap.get(key));
                config.append("\n");
            }
        }
        return config.toString();
    }

    public ActionForward streetSearch(DynActionForm form, ConnectionSet conSet) throws Exception {
        AddressDAO addressDAO = new AddressDAO(conSet.getSlaveConnection());
        String paramTitle = form.getParam("title", "");
        List<String> title = Utils.toList(paramTitle, " ").stream().map(LikePattern.SUB::get).collect(Collectors.toList());
        if ("substring".equals(this.setup.get("address.street.search.mode"))) {
            title = Utils.isEmptyString(paramTitle) ? null : List.of(LikePattern.SUB.get(paramTitle));
        }
        Set<Integer> cityIds = Utils.toIntegerSet(form.getPermission().get("cityIds"));
        Pageable<AddressItem> searchResult = new Pageable<AddressItem>(form);
        addressDAO.searchAddressStreetList(searchResult, cityIds, title, true, true);
        return this.json(conSet, form);
    }

    public ActionForward houseSearch(DynActionForm form, ConnectionSet conSet) throws Exception {
        AddressDAO addressDAO = new AddressDAO(conSet.getSlaveConnection());
        int streetId = Utils.parseInt(form.getParam("streetId"));
        String house = form.getParam("house", "");
        Pageable<AddressHouse> searchResult = new Pageable<AddressHouse>(form);
        addressDAO.searchAddressHouseList(searchResult, streetId, house);
        return this.json(conSet, form);
    }
}

