/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.fulltext.exec;

import java.sql.Connection;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exec.Runnable;
import org.bgerp.util.Log;
import ru.bgcrm.plugin.fulltext.dao.SearchDAO;
import ru.bgcrm.plugin.fulltext.model.Config;

public class FullTextInit
implements Runnable {
    private static final Log log = Log.getLog();

    @Override
    public void run() {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            con.setAutoCommit(true);
            Config config = Setup.getSetup().getConfig(Config.class);
            SearchDAO dao = new SearchDAO(con);
            this.initIfConfigured(config, dao, "customer", " customer ");
            this.initIfConfigured(config, dao, "process", " process ");
            this.initIfConfigured(config, dao, "message", " message ");
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private void initIfConfigured(Config config, SearchDAO dao, String objectType, String objectTable) throws Exception {
        if (config.getObjectTypeMap().containsKey(objectType)) {
            dao.init(objectType, objectTable);
        }
    }
}

