/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.tree.IdTitleTreeItem;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.UserInfo;
import ru.bgcrm.util.Utils;

public class DirectoryDAO
extends BillingDAO {
    private static final List<IdTitle> FIXED_OLD_STATUS_LIST = new ArrayList<IdTitle>();

    public DirectoryDAO(User user, String billingId) {
        super(user, billingId);
    }

    public DirectoryDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    public List<IdTitle> getContractStatusList(boolean onlyManual) {
        List result = null;
        if (this.dbInfo.versionCompare("5.2") < 0) {
            result = FIXED_OLD_STATUS_LIST;
        } else if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractStatusService", "getStatusList");
            req.setParam("onlyManual", onlyManual);
            result = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        } else {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.status", "ContractStatusMonitorService", "getStatusList");
            req.setParam("onlyManual", onlyManual);
            result = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        }
        return result;
    }

    public List<IdTitle> scriptTypeList() {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("ListDirectory");
        request.setAttribute("mode", "15");
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        ArrayList<IdTitle> scriptTypeList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle type = new IdTitle();
            type.setId(Utils.parseInt(rowElement.getAttribute("id")));
            type.setTitle(rowElement.getAttribute("title"));
            scriptTypeList.add(type);
        }
        return scriptTypeList;
    }

    public IdTitleTreeItem getContractPaymentTypes(Set<Integer> allowedTypeIds) {
        IdTitleTreeItem contractPaymentTypes = new IdTitleTreeItem();
        contractPaymentTypes.setTitle("\u0412\u0441\u0435 \u0442\u0438\u043f\u044b");
        if (this.dbInfo.versionCompare("6.1") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.balance", "PaymentService", "paymentTypeTree");
            req.setParam("editable", 0);
            req.setParam("showEmptyRoot", false);
            JsonNode result = this.transferData.postDataReturn(req, this.user);
            contractPaymentTypes = (IdTitleTreeItem)this.jsonMapper.convertValue((Object)result, IdTitleTreeItem.class);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ContractPayment");
            request.setAttribute("id", "new");
            Document document = this.transferData.postData(request, this.user);
            Element dataElement = document.getDocumentElement();
            NodeList nodeList = dataElement.getElementsByTagName("item");
            IdTitleTreeItem typeClass = new IdTitleTreeItem();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element itemElement = (Element)nodeList.item(index);
                int typeId = Utils.parseInt(itemElement.getAttribute("id"));
                if (!allowedTypeIds.isEmpty() && !allowedTypeIds.contains(typeId)) continue;
                if ("1".equals(itemElement.getAttribute("type"))) {
                    if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                        contractPaymentTypes.addChild(typeClass);
                    }
                    typeClass = new IdTitleTreeItem();
                    typeClass.setId(typeId);
                    typeClass.setTitle(itemElement.getAttribute("title"));
                    continue;
                }
                IdTitleTreeItem type = new IdTitleTreeItem();
                type.setId(typeId);
                type.setTitle(itemElement.getAttribute("title"));
                typeClass.addChild(type);
            }
            if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                contractPaymentTypes.addChild(typeClass);
            }
        }
        return contractPaymentTypes;
    }

    public List<IdTitle> paymentTypeList() {
        RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.balance", "PaymentService", "paymentTypeList");
        return (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
    }

    public IdTitleTreeItem getContractChargeTypes(Set<Integer> allowedTypeIds) {
        IdTitleTreeItem contractChargeTypes = new IdTitleTreeItem();
        contractChargeTypes.setTitle("\u0412\u0441\u0435 \u0442\u0438\u043f\u044b");
        if (this.dbInfo.versionCompare("6.1") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.balance", "ChargeService", "chargeTypeTree");
            req.setParam("editable", 0);
            req.setParam("isPayback", false);
            req.setParam("showEmptyRoot", false);
            JsonNode result = this.transferData.postDataReturn(req, this.user);
            contractChargeTypes = (IdTitleTreeItem)this.jsonMapper.convertValue((Object)result, IdTitleTreeItem.class);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ContractCharge");
            request.setAttribute("id", "new");
            Document document = this.transferData.postData(request, this.user);
            Element dataElement = document.getDocumentElement();
            NodeList nodeList = dataElement.getElementsByTagName("item");
            IdTitleTreeItem typeClass = new IdTitleTreeItem();
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element itemElement = (Element)nodeList.item(index);
                int typeId = Utils.parseInt(itemElement.getAttribute("id"));
                if (!allowedTypeIds.isEmpty() && !allowedTypeIds.contains(typeId)) continue;
                if ("1".equals(itemElement.getAttribute("type"))) {
                    if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                        contractChargeTypes.addChild(typeClass);
                    }
                    typeClass = new IdTitleTreeItem();
                    typeClass.setId(typeId);
                    typeClass.setTitle(itemElement.getAttribute("title"));
                    continue;
                }
                IdTitleTreeItem type = new IdTitleTreeItem();
                type.setId(typeId);
                type.setTitle(itemElement.getAttribute("title"));
                typeClass.addChild(type);
            }
            if (Utils.notBlankString(typeClass.getTitle()) || !typeClass.getChildren().isEmpty()) {
                contractChargeTypes.addChild(typeClass);
            }
        }
        return contractChargeTypes;
    }

    public List<IdTitle> chargeTypeList() {
        RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.balance", "ChargeService", "chargeTypeList");
        return (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
    }

    public List<IdTitle> getServiceTypeList(int moduleId) {
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.module", "ModuleService", "moduleServiceList");
            req.setParam("moduleId", moduleId);
            return (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        }
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        Request req = new Request();
        req.setModule("service");
        req.setAction("GetServiceList");
        req.setModuleID(moduleId);
        Document doc = this.transferData.postData(req, this.user);
        for (Element e : XMLUtils.selectElements(doc, "/data/services/service")) {
            list.add(new IdTitle(Utils.parseInt(e.getAttribute("id")), e.getAttribute("title")));
        }
        return list;
    }

    public List<IdTitle> getBillingModuleList() {
        Request request = new Request();
        request.setModule("service");
        request.setAction("Modules");
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("module");
        ArrayList<IdTitle> moduleList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle module = new IdTitle();
            module.setId(Utils.parseInt(rowElement.getAttribute("id")));
            module.setTitle(rowElement.getAttribute("title"));
            moduleList.add(module);
        }
        return moduleList;
    }

    public List<UserInfo> getUserList() {
        RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.bgsecure", "UserService", "listUsers");
        JsonNode res = this.transferData.postDataReturn(req, this.user);
        return (List)this.readJsonValue(res.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, UserInfo.class));
    }

    public List<UserInfo> getUserInfoList() {
        RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.bgsecure", "UserService", "userInfoList");
        JsonNode res = this.transferData.postDataReturn(req, this.user);
        List result = (List)this.readJsonValue(res.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, UserInfo.class));
        return result.stream().filter(user -> !"customer".equals(user.getName())).toList();
    }

    public long getDirectoryVersion(String directoryItemClass, int moduleId) {
        RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.directory.api", "DirectoryService", "getVersion");
        req.setParam("directoryItemClass", directoryItemClass);
        req.setParam("moduleId", moduleId);
        return this.transferData.postDataReturn(req, this.user).longValue();
    }

    static {
        FIXED_OLD_STATUS_LIST.add(new IdTitle(0, "\u0430\u043a\u0442\u0438\u0432\u0435\u043d"));
        FIXED_OLD_STATUS_LIST.add(new IdTitle(2, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        FIXED_OLD_STATUS_LIST.add(new IdTitle(3, "\u0437\u0430\u043a\u0440\u044b\u0442"));
        FIXED_OLD_STATUS_LIST.add(new IdTitle(4, "\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"));
    }
}

