/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.model.process.wizard;

import java.sql.Connection;
import java.util.List;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.process.wizard.base.StepData;
import ru.bgcrm.model.process.wizard.base.WizardData;
import ru.bgcrm.plugin.bgbilling.model.process.wizard.BaseStep;
import ru.bgcrm.plugin.bgbilling.proto.dao.InetDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetService;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@Bean
public class ShowInetServiceStep
extends BaseStep {
    private final int inetModuleId;

    public ShowInetServiceStep(ConfigMap config) {
        super(config);
        this.inetModuleId = config.getInt("inetModuleId");
    }

    @Override
    public String getJsp() {
        return "/WEB-INF/jspf/user/plugin/bgbilling/process/wizard/step_show_inet_service.jsp";
    }

    @Override
    public StepData<?> data(WizardData data) {
        return new Data(this, data);
    }

    public static class Data
    extends StepData<ShowInetServiceStep> {
        private List<InetService> services;

        private Data(ShowInetServiceStep step, WizardData data) {
            super(step, data);
        }

        public List<InetService> getServices() {
            return this.services;
        }

        @Override
        public boolean isFilled(DynActionForm form, Connection con) throws Exception {
            CommonObjectLink contractLink = Utils.getFirst(new ProcessLinkDAO(con).getObjectLinksWithType(this.data.getProcess().getId(), "contract%"));
            if (contractLink == null) {
                return false;
            }
            Contract contract = new Contract(contractLink);
            InetDAO dao = new InetDAO(form.getUser(), contract.getBillingId(), ((ShowInetServiceStep)this.step).inetModuleId);
            this.services = dao.getServiceList(contract.getId());
            return true;
        }
    }
}

