/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.creator;

import java.sql.Connection;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exec.scheduler.Task;
import org.bgerp.util.Log;
import ru.bgcrm.plugin.bgbilling.creator.Config;
import ru.bgcrm.plugin.bgbilling.creator.ServerCustomerCreator;

@Bean
public class CustomerCreator
extends Task {
    private static final Log log = Log.getLog();

    public CustomerCreator() {
        super(null);
    }

    @Override
    public String getTitle() {
        return "BGBilling \u0438\u043c\u043f\u043e\u0440\u0442 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u043e\u0432";
    }

    @Override
    public void run() {
        Setup setup = Setup.getSetup();
        try (Connection con = setup.getDBConnectionFromPool();){
            Config config = setup.getConfig(Config.class);
            for (ServerCustomerCreator c : config.serverCreatorList) {
                if (config.importBillingIds.size() != 0 && !config.importBillingIds.contains(c.getBillingId())) {
                    log.info("Skipping import: {}", c.getBillingId());
                    continue;
                }
                c.createCustomers(con);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

