/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.UserCache;
import org.bgerp.model.base.Id;
import org.bgerp.util.sql.pool.ConnectionPool;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.TransferData;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.directory.Directory;
import ru.bgcrm.plugin.bgbilling.proto.model.UserInfo;

public class DBInfo {
    private final ConfigMap setup;
    private final String id;
    private final String url;
    private final URL serverUrl;
    private final String title;
    private String version;
    private final ConnectionPool connectionPool;
    private final BiMap<Integer, Integer> billingUserIdUserIdBiMap = HashBiMap.create((int)100);
    private Set<String> pluginSet;
    private ConfigMap guiConfigValues;
    private final Map<String, Directory<?>> directories = new ConcurrentHashMap();

    public DBInfo(ConfigMap config) {
        this.id = config.get("id");
        this.setup = config;
        this.url = config.get("url");
        try {
            this.serverUrl = new URI(this.url).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new BGException(ex);
        }
        this.title = config.get("title");
        this.version = config.get("version", "");
        this.connectionPool = new ConnectionPool("bgbilling-" + this.getId(), config);
    }

    public ConfigMap getSetup() {
        return this.setup;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public int versionCompare(String withVersion) {
        return new BigDecimal(this.version).compareTo(new BigDecimal(withVersion));
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public int getCustomerIdParam() {
        return this.setup.getInt("customerIdParam", 0);
    }

    public Set<String> getPluginSet() {
        return this.pluginSet;
    }

    public void setPluginSet(Set<String> pluginSet) {
        this.pluginSet = pluginSet;
    }

    public ConfigMap getGuiConfigValues() {
        return this.guiConfigValues;
    }

    public void setGuiConfigValues(ConfigMap config) {
        this.guiConfigValues = config;
    }

    public TransferData getTransferData() {
        return new TransferData(this);
    }

    public String getCopyParamMapping() {
        return this.setup.get("copyParamMapping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBInfo loadUsers(User requestUser) {
        if (this.billingUserIdUserIdBiMap.isEmpty()) {
            BiMap<Integer, Integer> biMap = this.billingUserIdUserIdBiMap;
            synchronized (biMap) {
                Map<String, Integer> billingLoginUserId = new DirectoryDAO(requestUser, this).getUserList().stream().collect(Collectors.toMap(UserInfo::getLogin, Id::getId));
                for (User user : UserCache.getUserMap().values()) {
                    Integer billingUserId = user.getConfigMap().getInt("bgbilling:userId." + this.id, 0);
                    if (billingUserId > 0) {
                        this.billingUserIdUserIdBiMap.put((Object)billingUserId, (Object)user.getId());
                        continue;
                    }
                    billingUserId = billingLoginUserId.get(user.getLogin());
                    if (billingUserId == null) continue;
                    this.billingUserIdUserIdBiMap.put((Object)billingUserId, (Object)user.getId());
                }
            }
        }
        return this;
    }

    public int getBillingUserId(int userId) {
        return (Integer)this.billingUserIdUserIdBiMap.inverse().get((Object)userId);
    }

    public int getUserId(int billingUserId) {
        Integer value = (Integer)this.billingUserIdUserIdBiMap.get((Object)billingUserId);
        return value != null ? value : -1;
    }

    public <D extends Directory<?>> D directory(Class<D> clazz) {
        boolean moduleId = false;
        String key = clazz.getName() + ":0";
        return (D)this.directories.computeIfAbsent(key, unused -> {
            try {
                return (Directory)clazz.getDeclaredConstructor(DBInfo.class, Integer.TYPE).newInstance(this, 0);
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        });
    }
}

