/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.wizard;

import java.sql.Connection;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import ru.bgcrm.model.process.wizard.base.Step;
import ru.bgcrm.model.process.wizard.base.StepData;
import ru.bgcrm.model.process.wizard.base.WizardData;
import ru.bgcrm.struts.form.DynActionForm;

@Bean
public class ContinueStep
extends Step {
    private static final Log log = Log.getLog();
    private final Parameter param;

    public ContinueStep(ConfigMap config) {
        super(config);
        int paramId = config.getInt("parameterId", 0);
        this.param = ParameterCache.getParameter(paramId);
        if (this.param == null) {
            log.error("Not found param: {}", paramId);
        }
    }

    public Parameter getParam() {
        return this.param;
    }

    @Override
    public String getJsp() {
        return "/WEB-INF/jspf/user/process/wizard/step_continue.jsp";
    }

    @Override
    public StepData<?> data(WizardData data) {
        return new Data(this, data);
    }

    public static class Data
    extends StepData<ContinueStep> {
        private boolean filled = false;

        private Data(ContinueStep step, WizardData data) {
            super(step, data);
        }

        @Override
        public boolean isFilled(DynActionForm form, Connection con) throws Exception {
            this.filled = new ParamValueDAO(con).isParameterFilled(this.data.getProcess().getId(), ((ContinueStep)this.step).getParam());
            return this.filled;
        }

        public boolean isFilled() {
            return this.filled;
        }

        public int getProcessId() {
            return this.data.getProcess().getId();
        }
    }
}

