/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.UserCache;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.user.User;
import ru.bgcrm.model.user.UserGroup;
import ru.bgcrm.util.Utils;

public class ProcessExecutor {
    private int userId;
    private int groupId;
    private int roleId;

    public ProcessExecutor() {
    }

    public ProcessExecutor(int userId, int groupId) {
        this(userId, groupId, 0);
    }

    public ProcessExecutor(int userId, int groupId, int roleId) {
        if (groupId < 0) {
            groupId = 0;
        }
        if (roleId < 0) {
            roleId = 0;
        }
        this.groupId = groupId;
        this.roleId = roleId;
        this.userId = userId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    public boolean isInProcessGroup(ProcessGroup pg) {
        return this.getGroupId() == pg.getGroupId() && this.getRoleId() == pg.getRoleId();
    }

    public ProcessExecutor clone() {
        return new ProcessExecutor(this.userId, this.groupId, this.roleId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId;
        result = 31 * result + this.roleId;
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessExecutor other = (ProcessExecutor)obj;
        if (this.groupId != other.groupId) {
            return false;
        }
        if (this.roleId != other.roleId) {
            return false;
        }
        return this.userId == other.userId;
    }

    public static final Set<ProcessExecutor> parseSafe(String value, Set<ProcessGroup> processGroups) {
        LinkedHashSet<ProcessExecutor> resultSet = new LinkedHashSet<ProcessExecutor>();
        Set<String> parsedValues = Utils.toSet(value, ",");
        for (String item : parsedValues) {
            List<Integer> parsedSet = Utils.toIntegerList(item, ":");
            if (parsedSet.size() > 1) {
                resultSet.add(new ProcessExecutor(parsedSet.get(0), parsedSet.get(1), parsedSet.size() == 3 ? parsedSet.get(2) : 0));
                continue;
            }
            if (parsedSet.size() != 1) continue;
            boolean groupExist = false;
            for (UserGroup userGroup : UserCache.getUserGroupList(parsedSet.get(0))) {
                for (ProcessGroup processGroup : processGroups) {
                    if (userGroup.getGroupId() != processGroup.getGroupId()) continue;
                    if (ProcessGroup.isGroupWithRoleExist(processGroups, processGroup.getGroupId(), 0)) {
                        resultSet.add(new ProcessExecutor(parsedSet.get(0), processGroup.getGroupId(), 0));
                    } else {
                        resultSet.add(new ProcessExecutor(parsedSet.get(0), 0, 0));
                    }
                    groupExist = true;
                    break;
                }
                if (!groupExist) continue;
                break;
            }
            if (groupExist) continue;
            resultSet.add(new ProcessExecutor(parsedSet.get(0), 0, 0));
        }
        return resultSet;
    }

    public static final Set<ProcessExecutor> parseUnsafe(Set<String> values, Set<ProcessGroup> processGroups) {
        LinkedHashSet<ProcessExecutor> resultSet = new LinkedHashSet<ProcessExecutor>();
        for (String item : values) {
            List<Integer> parsedList = Utils.toIntegerList(item, ":");
            if (parsedList.size() > 1) {
                resultSet.add(new ProcessExecutor(parsedList.get(0), parsedList.get(1), parsedList.size() == 3 ? parsedList.get(2) : 0));
                continue;
            }
            if (parsedList.size() != 1) continue;
            User user = UserCache.getUser(parsedList.get(0));
            HashSet<Integer> processGroupIds = new HashSet<Integer>();
            for (ProcessGroup processGroup : processGroups) {
                if (!user.getGroupIds().contains(processGroup.getGroupId())) continue;
                processGroupIds.add(processGroup.getGroupId());
            }
            if (processGroupIds.size() != 1) {
                throw new BGException("\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c \u0441\u043e\u0441\u0442\u043e\u0438\u0442 \u043b\u0438\u0431\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043b, \u0432 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u0433\u0440\u0443\u043f\u043f\u0430\u0445 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430, \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0435\u0433\u043e \u0433\u0440\u0443\u043f\u043f\u0443 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.", new Object[0]);
            }
            resultSet.add(new ProcessExecutor(parsedList.get(0), (Integer)Utils.getFirst(processGroupIds), 0));
        }
        return resultSet;
    }

    public static final String serialize(Set<ProcessExecutor> processExecutors) {
        StringBuilder result = new StringBuilder();
        if (processExecutors == null) {
            return "";
        }
        for (ProcessExecutor processExecutor : processExecutors) {
            Utils.addCommaSeparated(result, processExecutor.getUserId() + ":" + processExecutor.getGroupId() + (String)(processExecutor.getRoleId() == 0 ? "" : ":" + processExecutor.getRoleId()));
        }
        return result.toString();
    }

    public static final Set<Integer> toGroupSet(Set<ProcessExecutor> processExecutors) {
        HashSet<Integer> resultSet = new HashSet<Integer>();
        for (ProcessExecutor processExecutor : processExecutors) {
            resultSet.add(processExecutor.getGroupId());
        }
        return resultSet;
    }

    public static final Set<Integer> toExecutorSet(Set<ProcessExecutor> processExecutors) {
        HashSet<Integer> resultSet = new HashSet<Integer>();
        for (ProcessExecutor processExecutor : processExecutors) {
            resultSet.add(processExecutor.getUserId());
        }
        return resultSet;
    }

    public static final Set<ProcessExecutor> toProcessExecutorSet(Set<Integer> userIds, ProcessGroup processGroup) {
        HashSet<ProcessExecutor> result = new HashSet<ProcessExecutor>();
        for (Integer userId : userIds) {
            result.add(new ProcessExecutor(userId, processGroup.getGroupId(), processGroup.getRoleId()));
        }
        return result;
    }

    public static final Set<ProcessExecutor> getProcessExecutors(Set<ProcessExecutor> processExecutors, ProcessGroup processGroup) {
        return ProcessExecutor.getProcessExecutors(processExecutors, Collections.singleton(processGroup));
    }

    public static final Set<ProcessExecutor> getProcessExecutors(Set<ProcessExecutor> processExecutors, Set<ProcessGroup> processGroups) {
        HashSet<ProcessExecutor> result = new HashSet<ProcessExecutor>();
        for (ProcessExecutor pe : processExecutors) {
            if (!processGroups.contains(pe.createProcessGroup())) continue;
            result.add(pe);
        }
        return result;
    }

    public ProcessGroup createProcessGroup() {
        return new ProcessGroup(this.groupId, this.roleId);
    }

    public static final void updateProcessExecutors(Set<ProcessExecutor> processExecutors, ProcessGroup processGroup, Set<Integer> executorIds) {
        Iterator<ProcessExecutor> it = processExecutors.iterator();
        while (it.hasNext()) {
            ProcessExecutor processExecutor = it.next();
            if (!processExecutor.isInProcessGroup(processGroup)) continue;
            it.remove();
        }
        processExecutors.addAll(ProcessExecutor.toProcessExecutorSet(executorIds, processGroup));
    }

    public static Set<Integer> getExecutorsWithRole(Set<ProcessExecutor> processExecutorSet, int role) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (ProcessExecutor value : processExecutorSet) {
            if (value.getRoleId() != role) continue;
            result.add(value.getUserId());
        }
        return result;
    }
}

