/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.param;

import org.bgerp.app.exception.BGMessageException;
import ru.bgcrm.util.Utils;

public class ParameterEmailValue {
    private String value;
    private String comment;

    public ParameterEmailValue() {
    }

    public ParameterEmailValue(String email) {
        this.value = email;
        this.comment = "";
    }

    public ParameterEmailValue(String email, String comment) {
        this.value = email;
        this.comment = comment;
    }

    public void setValue(String value) throws BGMessageException {
        if (!Utils.isValidEmail(value)) {
            throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 email!", new Object[0]);
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getUsername() {
        if (this.value.indexOf("@") == -1) {
            return "";
        }
        return this.value.split("@")[0];
    }

    public String getDomain() {
        try {
            return this.value.split("@")[1];
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        if (Utils.notBlankString(this.comment)) {
            return this.comment + " <" + this.value + ">";
        }
        return this.value;
    }

    public static final String toString(Iterable<ParameterEmailValue> emails) {
        StringBuilder result = new StringBuilder();
        for (ParameterEmailValue val : emails) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(val.toString());
        }
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterEmailValue other = (ParameterEmailValue)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

