/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.cache.UserCache;
import org.bgerp.cache.UserNewsCache;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.News;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;

public class NewsDAO
extends CommonDAO {
    public NewsDAO(Connection con) {
        super(con);
    }

    public void searchNewsList(Pageable<News> searchResult, int userId, Boolean read, String text) throws SQLException {
        Page page = searchResult.getPage();
        List<News> result = searchResult.getList();
        PreparedQuery pq = new PreparedQuery(this.con);
        pq.addQuery("SELECT SQL_CALC_FOUND_ROWS  * FROM  news  AS n INNER JOIN  news_user  AS u ON n.id=u.news_id WHERE u.user_id=? ");
        pq.addInt(userId);
        if (read != null) {
            if (read.booleanValue()) {
                pq.addQuery("AND is_read ");
            } else {
                pq.addQuery("AND NOT(is_read) ");
            }
        }
        if (Utils.notBlankString(text)) {
            pq.addQuery(" AND (POSITION(? IN n.title)>0 OR POSITION(? IN n.text)>0) ");
            pq.addString(text);
            pq.addString(text);
        }
        pq.addQuery("ORDER BY n.create_dt DESC ");
        pq.addQuery(page.getLimitSql());
        ResultSet rs = pq.executeQuery();
        while (rs.next()) {
            News news = this.getNewsFromRs(rs);
            news.setRead(rs.getBoolean("is_read"));
            result.add(news);
        }
        if (page != null) {
            page.setRecordCount(pq.getPrepared());
        }
        pq.close();
    }

    public News getNews(int newsId) throws SQLException {
        News news = new News();
        String query = "SELECT * FROM  news  WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, newsId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            news = this.getNewsFromRs(rs);
        }
        ps.close();
        return news;
    }

    public int updateNews(News news) throws SQLException {
        int index = 1;
        String query = null;
        PreparedStatement ps = null;
        if (news.getId() <= 0) {
            query = "INSERT INTO  news  SET create_dt=now(), title=?, text=?, user_id=?, is_popup=?, life_time=?, read_time=?";
            ps = this.con.prepareStatement(query, 1);
            ps.setString(index++, news.getTitle());
            ps.setString(index++, news.getText());
            ps.setInt(index++, news.getUserId());
            ps.setBoolean(index++, news.isPopup());
            ps.setInt(index++, news.getLifeTime());
            ps.setInt(index++, news.getReadTime());
            ps.executeUpdate();
            news.setId(this.lastInsertId(ps));
        } else {
            query = "UPDATE  news  SET update_dt=now(), title=?, text=?, user_id=?, is_popup=?, life_time=?, read_time=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setString(index++, news.getTitle());
            ps.setString(index++, news.getText());
            ps.setInt(index++, news.getUserId());
            ps.setBoolean(index++, news.isPopup());
            ps.setInt(index++, news.getLifeTime());
            ps.setInt(index++, news.getId());
            ps.setInt(index++, news.getReadTime());
            ps.executeUpdate();
        }
        ps.close();
        return news.getId();
    }

    public void updateNewsUsers(News news, Set<Integer> userIds) throws SQLException {
        this.deleteNewsUser(news.getId());
        news.setId(this.updateNews(news));
        for (Integer userId : userIds) {
            this.updateNewsUser(news, userId);
        }
        UserNewsCache.flushCache(this.con, userIds);
    }

    public void updateNewsGroups(News news, Set<Integer> groupIds) throws SQLException {
        HashSet<Integer> userIds = new HashSet<Integer>();
        for (User user : UserCache.getUserList()) {
            if (CollectionUtils.intersection(user.getGroupIds(), groupIds).size() <= 0) continue;
            userIds.add(user.getId());
        }
        this.updateNewsUsers(news, userIds);
        String query = "UPDATE  news  SET `groups`=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, Utils.toString(groupIds));
        ps.setInt(2, news.getId());
        ps.executeUpdate();
        ps.close();
    }

    public void setNewsRead(int newsId, int userId, boolean value) throws SQLException {
        int index = 1;
        String query = "UPDATE  news_user  SET is_read=? WHERE news_id=? AND user_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setBoolean(index++, value);
        ps.setInt(index++, newsId);
        ps.setInt(index++, userId);
        ps.executeUpdate();
        ps.close();
    }

    public void setNewsAllRead(int userId) throws SQLException {
        int index = 1;
        String query = "UPDATE  news_user  SET is_read=1 WHERE user_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(index++, userId);
        ps.executeUpdate();
        ps.close();
    }

    private void updateNewsUser(News news, int userId) throws SQLException {
        int index = 1;
        String query = "INSERT INTO  news_user  SET news_id=?, user_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(index++, news.getId());
        ps.setInt(index++, userId);
        ps.executeUpdate();
        ps.close();
    }

    private News getNewsFromRs(ResultSet rs) throws SQLException {
        News news = new News();
        news.setId(rs.getInt("id"));
        news.setUserId(rs.getInt("user_id"));
        news.setCreateTime(rs.getTimestamp("create_dt"));
        news.setUpdateTime(rs.getTimestamp("update_dt"));
        news.setTitle(rs.getString("title"));
        news.setText(rs.getString("text"));
        news.setPopup(rs.getBoolean("is_popup"));
        news.setLifeTime(rs.getInt("life_time"));
        news.setReadTime(rs.getInt("read_time"));
        news.setGroupIds(Utils.toIntegerSet(rs.getString("groups")));
        return news;
    }

    public void deleteNews(int newsId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM  news  WHERE id=?");
        ps.setInt(1, newsId);
        ps.executeUpdate();
        ps.close();
        HashSet<Integer> newsUserIds = new HashSet<Integer>();
        ps = this.con.prepareStatement("SELECT user_id FROM  news_user  WHERE news_id=?");
        ps.setInt(1, newsId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            newsUserIds.add(rs.getInt(1));
        }
        ps.close();
        UserNewsCache.flushCache(this.con, newsUserIds);
        this.deleteNewsUser(newsId);
    }

    private void deleteNewsUser(int newsId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM  news_user  WHERE news_id=?");
        ps.setInt(1, newsId);
        ps.executeUpdate();
        ps.close();
    }
}

