/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.sql.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.ConfigMap;

class TrashDatabaseSelector {
    private List<TableMapRow> configRowList = new ArrayList<TableMapRow>();

    public TrashDatabaseSelector(ConfigMap setup) {
        ConfigMap configRows = setup.sub("trash.table.map.");
        for (Map.Entry<String, String> me : configRows.entrySet()) {
            String prefix = me.getKey();
            int pos = prefix.indexOf(46);
            if (pos <= 0) continue;
            prefix = prefix.substring(pos + 1);
            TableMapRow row = new TableMapRow();
            row.tablePrefix = prefix;
            row.database = me.getValue();
            this.configRowList.add(row);
        }
    }

    public String getDatabaseName(String tableName) {
        String result = null;
        for (TableMapRow row : this.configRowList) {
            if (!tableName.startsWith(row.tablePrefix)) continue;
            result = row.database;
            break;
        }
        return result;
    }

    private static class TableMapRow {
        public String tablePrefix;
        public String database;

        private TableMapRow() {
        }
    }
}

