/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.bouncycastle.util.Arrays;

public class Log {
    public static final String MSG_DEPRECATED_METHOD_WAS_CALLED = "Deprecated method '{}' was called.";
    public static final String MSG_WS_CREATE_NEW_INSTANCE_INSTEAD = " Create a new instance using 'new' instead.";
    private final Logger logger;

    public static Log getLog(Class<?> clazz) {
        return new Log(Logger.getLogger(clazz));
    }

    public static Log getLog() {
        return Log.getLog(StackLocatorUtil.getCallerClass((int)2));
    }

    public static String format(String message, Object ... args) {
        return new FormattedMessage(message, args).getFormattedMessage();
    }

    protected Log(Logger logger) {
        this.logger = logger;
    }

    public void trace(String message, Object ... params) {
        this.log((Priority)Level.TRACE, message, params);
    }

    public void debug(String message, Object ... args) {
        this.log((Priority)Level.DEBUG, message, args);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(String message, Object ... args) {
        this.log((Priority)Level.INFO, message, args);
    }

    public void warn(String message, Object ... args) {
        this.log((Priority)Level.WARN, message, args);
    }

    public void warnd(String message, Object ... args) {
        this.warn(message, args);
    }

    public void warndMethod(String deprecatedName, String actualName) {
        if (actualName == null) {
            this.warn(MSG_DEPRECATED_METHOD_WAS_CALLED, deprecatedName);
        } else {
            this.warn("Deprecated method '{}' was called. Use '{}' instead.", deprecatedName, actualName);
        }
    }

    public void warndMethod(String deprecatedName) {
        this.warndMethod(deprecatedName, null);
    }

    public void warndClass(Class<?> deprecatedClass, Class<?> actualClass) {
        this.warnd("Deprecated class '{}' was created, use '{}' instead", deprecatedClass.getName(), actualClass.getName());
    }

    public void warndJsp(String deprecatedCall, String actionCall) {
        this.warn("Deprecated JSP call '{}', use '{}' instead.", deprecatedCall, actionCall);
    }

    public void error(String message, Object ... args) {
        this.log((Priority)Level.ERROR, message, args);
    }

    public void error(Throwable e) {
        this.logger.error((Object)e.getMessage(), e);
    }

    public void error(String message, Throwable e) {
        this.logger.error((Object)message, e);
    }

    public final void log(Priority level, Object message) {
        this.logger.log(level, message);
    }

    private final void log(Priority level, String message, Object ... args) {
        if (this.logger.isEnabledFor(level)) {
            this.logger.log(level, (Object)(Arrays.isNullOrEmpty((Object[])args) ? message : Log.format(message, args)));
        }
    }
}

