/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.log.model;

import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.bgerp.app.servlet.filter.AuthFilter;
import org.bgerp.app.servlet.user.event.ActionRequestEvent;
import org.bgerp.app.servlet.util.ServletUtils;
import org.bgerp.model.base.Id;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;

public class ActionLogEntry
extends Id {
    private int userId;
    private String ipAddress;
    private String action = "";
    private String parameters;
    private Date time;
    private long duration;
    private String error;

    public ActionLogEntry() {
    }

    public ActionLogEntry(ActionRequestEvent e) {
        HttpServletRequest request = e.getRequest();
        StringBuilder queryString = new StringBuilder(200);
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String[] entryValue;
            for (String val : entryValue = (String[])entry.getValue()) {
                queryString.append((String)entry.getKey()).append("=").append(val).append("\n");
            }
        }
        this.parameters = queryString.toString();
        User user = AuthFilter.getUser(request);
        if (user != null) {
            this.userId = user.getId();
        }
        this.action = e.getAction();
        this.ipAddress = ServletUtils.getHttpRequestRemoteAddr(request);
        this.duration = e.getDuration();
        this.error = Utils.maskNull(e.getError());
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int value) {
        this.userId = value;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getParameters() {
        return this.parameters == null ? "" : this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }
}

