/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.log.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.model.Pageable;
import org.bgerp.plugin.svc.log.model.ActionLogEntry;
import org.bgerp.util.sql.LikePattern;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.PeriodicDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.util.Utils;

public class ActionLogDAO
extends PeriodicDAO {
    private static final String TABLE_NAME_PREFIX = "log_action";
    private Date timeFrom;
    private Date timeTo;
    private Set<Integer> userIds;
    private String ipAddress;
    private Set<String> actions;
    private String parameter;

    public ActionLogDAO(Connection con) {
        super(con);
    }

    public void update(ActionLogEntry entry) throws SQLException {
        String table = this.checkAndCreateMonthTable(TABLE_NAME_PREFIX, new Date(), "(`id` INT NOT NULL AUTO_INCREMENT, `user_id` INT NOT NULL, `ip_address` VARCHAR(15) NOT NULL , `action` VARCHAR(200) NOT NULL , `parameters` TEXT NOT NULL , `time` DATETIME NOT NULL, `duration` BIGINT NOT NULL , `error` TEXT NOT NULL, PRIMARY KEY (`id`), KEY `user_id` (`user_id`), KEY `time` (`time`))");
        String query = "INSERT INTO " + table + "(time, user_id, ip_address, action, parameters, duration, error) VALUES (NOW(), ?, ?, ?, ?, ?, ?)";
        PreparedQuery pq = new PreparedQuery(this.con, query);
        pq.addInt(entry.getUserId()).addString(entry.getIpAddress()).addString(entry.getAction()).addString(entry.getParameters()).addLong(entry.getDuration()).addString(entry.getError());
        pq.executeInsert();
        pq.close();
    }

    public ActionLogDAO withTimeFrom(Date value) {
        this.timeFrom = value;
        return this;
    }

    public ActionLogDAO withTimeTo(Date value) {
        this.timeTo = value;
        return this;
    }

    public ActionLogDAO withUserIds(Set<Integer> value) {
        this.userIds = value;
        return this;
    }

    public ActionLogDAO withIpAddress(String value) {
        this.ipAddress = value;
        return this;
    }

    public ActionLogDAO withActions(Set<String> value) {
        this.actions = value;
        return this;
    }

    public ActionLogDAO withParameter(String value) {
        this.parameter = value;
        return this;
    }

    public void search(Pageable<ActionLogEntry> result) throws SQLException {
        if (this.timeFrom == null) {
            throw new IllegalArgumentException("timeFrom can't be null");
        }
        String table = this.getMonthTableName(TABLE_NAME_PREFIX, this.timeFrom);
        if (!this.tableExists(table)) {
            return;
        }
        List<ActionLogEntry> list = result.getList();
        Page page = result.getPage();
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            pq.addQuery("SELECT DISTINCT SQL_CALC_FOUND_ROWS * FROM ").addQuery(table).addQuery(" WHERE ?<=time ").addDate(this.timeFrom);
            if (this.timeTo != null) {
                pq.addQuery(" AND time<? ").addDate(this.timeTo);
            }
            if (Utils.notBlankString(this.ipAddress)) {
                pq.addQuery(" AND ip_address=? ").addString(this.ipAddress);
            }
            if (CollectionUtils.isNotEmpty(this.userIds)) {
                pq.addQuery(" AND user_id IN (").addQuery(Utils.toString(this.userIds)).addQuery(") ");
            }
            if (CollectionUtils.isNotEmpty(this.actions)) {
                pq.addQuery(" AND action IN ('").addQuery(Utils.toString(this.actions, "", "','")).addQuery("') ");
            }
            if (Utils.notBlankString(this.parameter)) {
                pq.addQuery(" AND parameters LIKE '" + LikePattern.SUB.get(this.parameter) + "'");
            }
            pq.addQuery(" ORDER BY ").addQuery("time");
            pq.addQuery(page.getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                ActionLogEntry entry = new ActionLogEntry();
                entry.setId(rs.getInt("id"));
                entry.setUserId(rs.getInt("user_id"));
                entry.setAction(rs.getString("action"));
                entry.setParameters(rs.getString("parameters"));
                entry.setTime(rs.getTimestamp("time"));
                entry.setIpAddress(rs.getString("ip_address"));
                entry.setDuration(rs.getLong("duration"));
                entry.setError(rs.getString("error"));
                list.add(entry);
            }
            page.setRecordCount(pq.getPrepared());
        }
    }
}

