/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.dba.action.admin;

import java.sql.Connection;
import java.sql.Statement;
import java.time.YearMonth;
import java.util.List;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.plugin.svc.dba.Config;
import org.bgerp.plugin.svc.dba.dao.DatabaseDAO;
import org.bgerp.plugin.svc.dba.model.db.Table;
import org.bgerp.plugin.svc.dba.model.db.UnusedColumn;
import org.bgerp.util.Log;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/admin/plugin/dba/db", pathId=true)
public class DatabaseAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/plugin/dba";
    private static final String ACTION_DROP = ActionServlet.pathId(DatabaseAction.class, "drop");

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        List<Table> tables = new DatabaseDAO(conSet.getConnection()).tables();
        this.setup.getConfig(Config.class).dropCandidates(tables, YearMonth.now());
        Long rows = tables.stream().map(status -> status.getRows()).reduce(0L, Long::sum);
        form.setResponseData("rows", rows);
        Long size = tables.stream().map(status -> status.getDataLength() + status.getIndexLength()).reduce(0L, Long::sum);
        form.setResponseData("size", size);
        if (form.getUser().checkPerm(ACTION_DROP)) {
            int dropTableCandidatesCnt = 0;
            int dropColumnCandidatesCnt = 0;
            for (Table table : tables) {
                if (table.isDropCandidate()) {
                    ++dropTableCandidatesCnt;
                }
                dropColumnCandidatesCnt = (int)((long)dropColumnCandidatesCnt + table.getUnusedColumns().stream().filter(UnusedColumn::isDropCandidate).count());
            }
            form.setResponseData("dropStatus", Log.format("T: {} C: {}", dropTableCandidatesCnt, dropColumnCandidatesCnt));
        }
        form.setResponseData("tables", tables);
        return this.html(conSet, form, "/WEB-INF/jspf/admin/plugin/dba/database.jsp");
    }

    public ActionForward drop(DynActionForm form, Connection con) throws Exception {
        List<String> columns = form.getParamValuesListStr("column");
        List<String> tables = form.getParamValuesListStr("table");
        try (Statement st = con.createStatement();){
            for (String column : columns) {
                String[] table_column = column.split(":");
                st.executeUpdate("ALTER TABLE " + table_column[0] + " DROP COLUMN " + table_column[1]);
            }
            for (String table : tables) {
                st.executeUpdate("DROP TABLE " + table);
            }
        }
        return this.json(con, form);
    }
}

