/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model.config;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import ru.bgcrm.util.TimeUtils;

public class CallboardPlanConfig
extends Config {
    private final int dayMinuteFrom;
    private final int dayMinuteTo;
    private final int dayMinuteStep;

    public CallboardPlanConfig(ConfigMap setup) {
        super(null);
        this.dayMinuteFrom = setup.getInt("dayMinuteFrom", 0);
        this.dayMinuteTo = setup.getInt("dayMinuteTo", 0);
        this.dayMinuteStep = setup.getInt("dayMinuteStep", 60);
    }

    public int getDayMinuteFrom() {
        return this.dayMinuteFrom;
    }

    public int getDayMinuteTo() {
        return this.dayMinuteTo;
    }

    public int getDayMinuteStep() {
        return this.dayMinuteStep;
    }

    public Calendar getTimeFrom(Date date) {
        Calendar result = TimeUtils.convertDateToCalendar(date);
        result.add(12, this.dayMinuteFrom);
        return result;
    }

    public Calendar getTimeTo(Date date) {
        Calendar result = TimeUtils.convertDateToCalendar(date);
        result.add(12, this.dayMinuteTo);
        return result;
    }

    public List<Date> getDateTimes(Date date) {
        ArrayList<Date> result = new ArrayList<Date>();
        for (int minute = this.dayMinuteFrom; minute < this.dayMinuteTo; minute += this.dayMinuteStep) {
            Calendar time = TimeUtils.convertDateToCalendar(date);
            time.add(12, minute);
            result.add(TimeUtils.convertCalendarToDate(time));
        }
        return result;
    }
}

