/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.agree;

import java.util.Date;
import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.cache.UserCache;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.plugin.pln.agree.event.AgreementEvent;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.StatusChangeDAO;
import ru.bgcrm.event.process.ProcessChangedEvent;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

public class ProcessTypeConfig
extends Config {
    private final int statusFromId;
    private final int statusToId;
    private final int groupId;
    private final int roleId;
    private final int requiredQty;

    protected ProcessTypeConfig(ConfigMap config) throws Config.InitStopException {
        super(null);
        config = config.sub("agree:");
        this.statusFromId = config.getInt("status.from");
        this.statusToId = config.getInt("status.to");
        this.groupId = config.getInt("executor.group");
        this.roleId = config.getInt("executor.role", 0);
        this.requiredQty = config.getInt("required.qty", 1);
        this.initWhen(this.statusFromId > 0 && this.statusToId > 0 && this.groupId > 0);
    }

    public void statusChanged(ProcessChangedEvent event, ConnectionSet conSet, Process process) throws Exception {
        DynActionForm form = event.getForm();
        int statusId = process.getStatusId();
        ProcessDAO dao = new ProcessDAO(conSet.getConnection());
        if (statusId == this.statusFromId) {
            if (!process.getGroupIds().contains(this.groupId)) {
                ProcessGroups groups = process.getGroups();
                groups.add(new ProcessGroup(this.groupId, this.roleId));
                dao.updateProcessGroups(groups, process.getId());
            }
            Set<ProcessExecutor> executors = process.getExecutors();
            UserCache.getUserList().stream().filter(u -> u.getGroupIds().contains(this.groupId)).forEach(user -> executors.add(new ProcessExecutor(user.getId(), this.groupId, this.roleId)));
            dao.updateProcessExecutors(executors, process.getId());
            EventProcessor.processEvent(new AgreementEvent(form, process, AgreementEvent.Mode.START), conSet);
            event.stopProcessing();
        } else if (statusId == this.statusToId) {
            Localizer l = Localization.getLocalizer("agree", form.getHttpRequest());
            Set<ProcessExecutor> executors = process.getExecutors();
            if (!executors.removeIf(pe -> pe.getUserId() == form.getUserId() && pe.getGroupId() == this.groupId && pe.getRoleId() == this.roleId)) {
                throw new BGMessageException(l.l("Only members of {} group can do the status change", UserCache.getUserGroup(this.groupId).getTitle()), new Object[0]);
            }
            long fullQty = UserCache.getUserList().stream().filter(u -> u.getGroupIds().contains(this.groupId)).count();
            long leftQty = executors.stream().filter(pe -> pe.getGroupId() == this.groupId && pe.getRoleId() == this.roleId).count();
            if (this.requiredQty == 0 && leftQty == 0L || (long)this.requiredQty <= fullQty - leftQty) {
                log.debug("Agreement has done, process: {}", process.getId());
                EventProcessor.processEvent(new AgreementEvent(form, process, AgreementEvent.Mode.FINISH), conSet);
                event.stopProcessing();
            } else {
                log.debug("Agreement has not done, process: {}", process.getId());
                StatusChange statusChange = new StatusChange(process.getId(), new Date(), form.getUserId(), this.statusFromId, l.l("Not all the required executors have agreed", new Object[0]));
                new StatusChangeDAO(conSet.getConnection()).changeStatus(process, process.getType(), statusChange);
                EventProcessor.processEvent(new AgreementEvent(form, process, AgreementEvent.Mode.PROGRESS), conSet);
                event.stopProcessing();
            }
            dao.updateProcessExecutors(executors, process.getId());
        }
    }
}

