/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.queue.column;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.UserCache;
import org.bgerp.event.process.queue.QueueColumnEvent;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.dao.ParamValueSelect;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

@Dynamic
public class Column {
    private static final Log log = Log.getLog();
    private final String id;
    private final ConfigMap config;

    public static Column of(String id, ConfigMap config) throws Exception {
        Column result = new Column(id, config);
        QueueColumnEvent event = new QueueColumnEvent(result);
        EventProcessor.processEvent(event, null);
        if (event.getColumn() != null) {
            result = event.getColumn();
        }
        return result;
    }

    protected Column(String id, ConfigMap config) {
        this.id = id;
        this.config = config;
    }

    protected Column(Column column) {
        this.id = column.id;
        this.config = column.config;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.config.get("value");
    }

    public String getAggregate() {
        return this.config.get("aggregate");
    }

    private String getConvert() {
        return this.config.get("convert");
    }

    public String getTitle() {
        return this.config.get("title");
    }

    public int getTitleIfMore() {
        return this.config.getInt("titleIfMore");
    }

    public boolean isFormatToHtml() {
        return this.config.getBoolean("formatToHtml");
    }

    public int getCutIfMore() {
        return this.config.getInt("cutIfMore");
    }

    public String getShowAsLink() {
        return this.config.get("showAsLink");
    }

    public String getStyle() {
        String align;
        StringBuilder result = new StringBuilder(this.config.get("style", ""));
        if (this.config.getBoolean("nowrap")) {
            Utils.addSeparated(result, "; ", "white-space: nowrap");
        }
        if (Utils.notBlankString(align = this.config.get("align"))) {
            Utils.addSeparated(result, "; ", "text-align: " + align);
        }
        return result.toString();
    }

    public String getProcess() {
        return this.config.get("process", "process");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addQuery(StringBuilder selectPart, StringBuilder joinPart) throws Exception {
        Pair<String, String> modifiers;
        block36: {
            String value;
            block59: {
                block68: {
                    block67: {
                        block66: {
                            block65: {
                                block64: {
                                    block63: {
                                        block62: {
                                            block61: {
                                                block60: {
                                                    String target;
                                                    block58: {
                                                        block55: {
                                                            String tableAlias;
                                                            String statusString;
                                                            String whatSelect;
                                                            String statusList;
                                                            block57: {
                                                                block56: {
                                                                    block52: {
                                                                        String[] parameters;
                                                                        block54: {
                                                                            block53: {
                                                                                block51: {
                                                                                    block50: {
                                                                                        block49: {
                                                                                            block48: {
                                                                                                block47: {
                                                                                                    block46: {
                                                                                                        block45: {
                                                                                                            block44: {
                                                                                                                block43: {
                                                                                                                    block42: {
                                                                                                                        block39: {
                                                                                                                            String alias;
                                                                                                                            block41: {
                                                                                                                                block40: {
                                                                                                                                    block38: {
                                                                                                                                        block37: {
                                                                                                                                            value = this.getValue();
                                                                                                                                            if (value == null) {
                                                                                                                                                throw new BGException(".value not defined, column: " + this.getId(), new Object[0]);
                                                                                                                                            }
                                                                                                                                            target = this.getProcess();
                                                                                                                                            if ("linked".equals(target) && joinPart.indexOf(" LEFT JOIN  process_link  AS pllp ON pllp.object_id=process.id AND pllp.object_type LIKE 'process%'  LEFT JOIN  process  AS linked ON pllp.process_id=linked.id") < 0) {
                                                                                                                                                joinPart.append(" LEFT JOIN  process_link  AS pllp ON pllp.object_id=process.id AND pllp.object_type LIKE 'process%'  LEFT JOIN  process  AS linked ON pllp.process_id=linked.id");
                                                                                                                                            }
                                                                                                                                            modifiers = this.getModifiers();
                                                                                                                                            selectPart.append(modifiers.getFirst());
                                                                                                                                            if (!"check".equals(value) && !"id".equals(value)) break block37;
                                                                                                                                            selectPart.append(target + ".id ");
                                                                                                                                            break block36;
                                                                                                                                        }
                                                                                                                                        if (!"type_title".equals(value)) break block38;
                                                                                                                                        String alias2 = "type_" + target;
                                                                                                                                        selectPart.append(alias2 + ".title ");
                                                                                                                                        joinPart.append(" LEFT JOIN  process_type  AS " + alias2 + " ON " + target + ".type_id=" + alias2 + ".id");
                                                                                                                                        break block36;
                                                                                                                                    }
                                                                                                                                    if (!value.startsWith("status_")) break block39;
                                                                                                                                    alias = this.addProcessStatusJoin(target, joinPart);
                                                                                                                                    if (!"status_title".equals(value) && !"status_pos".equals(value)) break block40;
                                                                                                                                    String aliasPst = "process_status_title_" + target;
                                                                                                                                    if ("status_title".equals(value)) {
                                                                                                                                        selectPart.append(aliasPst + ".title ");
                                                                                                                                    } else {
                                                                                                                                        selectPart.append(aliasPst + ".pos ");
                                                                                                                                    }
                                                                                                                                    if (joinPart.indexOf(aliasPst) < 0) {
                                                                                                                                        joinPart.append(" LEFT JOIN process_status_title AS " + aliasPst + " ON " + target + ".status_id=" + aliasPst + ".id");
                                                                                                                                    }
                                                                                                                                    break block36;
                                                                                                                                }
                                                                                                                                if (!value.startsWith("status_dt")) break block41;
                                                                                                                                this.addDateTimeParam(selectPart, alias + ".dt", value);
                                                                                                                                break block36;
                                                                                                                            }
                                                                                                                            if ("status_user".equals(value)) {
                                                                                                                                String aliasPsu = "status_user_" + target;
                                                                                                                                selectPart.append(aliasPsu + ".title ");
                                                                                                                                joinPart.append(" LEFT JOIN user AS " + aliasPsu + " ON " + aliasPsu + ".id=" + alias + ".user_id ");
                                                                                                                                break block36;
                                                                                                                            } else if ("status_comment".equals(value)) {
                                                                                                                                selectPart.append(alias + ".comment");
                                                                                                                                break block36;
                                                                                                                            } else {
                                                                                                                                log.error("Incorrect column value macros: {}", value);
                                                                                                                                selectPart.append("'0' ");
                                                                                                                            }
                                                                                                                            break block36;
                                                                                                                        }
                                                                                                                        if (!"priority".equals(value)) break block42;
                                                                                                                        selectPart.append(target + ".priority ");
                                                                                                                        break block36;
                                                                                                                    }
                                                                                                                    if (!value.startsWith("create_dt")) break block43;
                                                                                                                    this.addDateTimeParam(selectPart, target + ".create_dt", value);
                                                                                                                    break block36;
                                                                                                                }
                                                                                                                if (!"create_user".equals(value) && !"creator".equals(value)) break block44;
                                                                                                                String alias = "create_user_" + target;
                                                                                                                selectPart.append(alias + ".title ");
                                                                                                                joinPart.append(" LEFT JOIN user AS " + alias + " ON " + alias + ".id=" + target + ".create_user_id ");
                                                                                                                break block36;
                                                                                                            }
                                                                                                            if (!value.startsWith("close_dt")) break block45;
                                                                                                            this.addDateTimeParam(selectPart, target + ".close_dt", value);
                                                                                                            break block36;
                                                                                                        }
                                                                                                        if (!"close_user".equals(value)) break block46;
                                                                                                        String alias = "close_user_" + target;
                                                                                                        selectPart.append(alias + ".title ");
                                                                                                        joinPart.append(" LEFT JOIN user AS " + alias + " ON " + alias + ".id=" + target + ".close_user_id ");
                                                                                                        break block36;
                                                                                                    }
                                                                                                    if (!value.startsWith("description")) break block47;
                                                                                                    selectPart.append(target + ".description ");
                                                                                                    break block36;
                                                                                                }
                                                                                                if (!value.startsWith("param") && !value.startsWith("text_param")) break block48;
                                                                                                ParamValueSelect.paramSelectQuery(value, target + ".id", selectPart, joinPart, false);
                                                                                                break block36;
                                                                                            }
                                                                                            if (!value.startsWith("ifListParam:")) break block49;
                                                                                            String[] parts = StringUtils.substringAfter((String)value, (String)"ifListParam:").split(":");
                                                                                            if (parts.length <= 1) {
                                                                                                log.warn("Wrong condition: {}", value);
                                                                                                return;
                                                                                            }
                                                                                            String existVal = "\u2713";
                                                                                            String notExistVal = "\u2717";
                                                                                            int paramId = Utils.parseInt(parts[0]);
                                                                                            int paramValue = Utils.parseInt(parts[1]);
                                                                                            Parameter param = ParameterCache.getParameter(paramId);
                                                                                            if (param != null && "list".equals(param.getType())) {
                                                                                                String alias = "param_" + paramId + "_list_value_" + paramValue;
                                                                                                if (parts.length > 2) {
                                                                                                    existVal = parts[2];
                                                                                                }
                                                                                                if (parts.length > 3) {
                                                                                                    notExistVal = parts[3];
                                                                                                }
                                                                                                selectPart.append(" IF(" + alias + ".value,'" + existVal + "','" + notExistVal + "') ");
                                                                                                joinPart.append(" LEFT JOIN  param_list  AS " + alias + " ON " + target + ".id= " + alias + ".id AND " + alias + ".param_id=" + paramId + " AND " + alias + ".value=" + paramValue + " ");
                                                                                            }
                                                                                            break block36;
                                                                                        }
                                                                                        if (!value.startsWith("linkCustomerLink") && !value.startsWith("linkedCustomerLink")) break block50;
                                                                                        String alias = value;
                                                                                        String columnAlias = alias + "Col";
                                                                                        String customerLinkType = StringUtils.substringAfter((String)value, (String)":");
                                                                                        selectPart.append("( SELECT GROUP_CONCAT( CONCAT( CONVERT( link.object_id, CHAR) , ':', " + alias + ".title) SEPARATOR '$' )  FROM  process_link  AS link  INNER JOIN  customer  AS " + alias + " ON link.object_id=" + alias + ".id  WHERE ");
                                                                                        if (Utils.notBlankString(customerLinkType)) {
                                                                                            selectPart.append("link.object_type='" + customerLinkType + "'");
                                                                                        } else {
                                                                                            selectPart.append("link.object_type LIKE 'customer%'");
                                                                                        }
                                                                                        selectPart.append(" AND link.process_id=" + target + ".id GROUP BY link.process_id ) AS " + columnAlias + " ");
                                                                                        break block36;
                                                                                    }
                                                                                    if (!value.startsWith("linkCustomer:") && !value.startsWith("linkedCustomer:")) break block51;
                                                                                    String[] parameters2 = value.split(":");
                                                                                    if (parameters2.length == 2) {
                                                                                        String alias = parameters2[0];
                                                                                        String table = "customer";
                                                                                        String column = parameters2[1];
                                                                                        selectPart.append("( SELECT GROUP_CONCAT(" + alias + "." + column + " SEPARATOR ', ') FROM process_link AS link  LEFT JOIN " + table + " AS " + alias + " ON link.object_id=" + alias + ".id WHERE link.object_type='" + table + "' AND link.process_id=" + target + ".id GROUP BY link.process_id ) AS " + table + " ");
                                                                                        break block36;
                                                                                    } else if (parameters2.length == 3 && parameters2[1].equals("param")) {
                                                                                        int paramId = Integer.parseInt(parameters2[2]);
                                                                                        if (joinPart.indexOf("linked_customer") < 0) {
                                                                                            joinPart.append(" LEFT JOIN  process_link  AS linked_customer ON " + target + ".id=linked_customer.process_id AND linked_customer.object_type='customer' ");
                                                                                        }
                                                                                        ParamValueSelect.paramSelectQuery("param:" + paramId, "linked_customer.object_id", selectPart, joinPart, false);
                                                                                    }
                                                                                    break block36;
                                                                                }
                                                                                if (!value.startsWith("linkObject:") && !value.startsWith("linkedObject:")) break block52;
                                                                                parameters = value.split(":");
                                                                                if (parameters.length < 2) {
                                                                                    return;
                                                                                }
                                                                                if (!parameters[1].startsWith("process")) break block53;
                                                                                String columnValue = parameters[1];
                                                                                selectPart.append(" ( SELECT GROUP_CONCAT(link.object_id SEPARATOR ', ') FROM process_link AS link  WHERE link.object_type='" + columnValue + "' AND link.process_id=" + target + ".id  GROUP BY link.process_id ) AS linked_process ");
                                                                                break block36;
                                                                            }
                                                                            if (!parameters[1].equals("contract")) break block54;
                                                                            selectPart.append(" ( SELECT GROUP_CONCAT(CONCAT(SUBSTRING_INDEX(link.object_type, ':', -1),':',CAST(link.object_id AS char),':',link.object_title) SEPARATOR ', ') FROM process_link AS link  WHERE link.object_type LIKE 'contract%' AND link.process_id=" + target + ".id  GROUP BY link.process_id ) AS contract ");
                                                                            break block36;
                                                                        }
                                                                        if (parameters[1].startsWith("contract")) {
                                                                            String columnValue = "contract";
                                                                            selectPart.append(" ( SELECT GROUP_CONCAT(link.object_title SEPARATOR ', ') FROM process_link AS link  WHERE link.object_type LIKE '" + columnValue + "%' AND link.process_id=" + target + ".id  GROUP BY link.process_id ) AS contract ");
                                                                            break block36;
                                                                        } else if (parameters.length > 2 && parameters[2].equals("id")) {
                                                                            selectPart.append(" ( SELECT GROUP_CONCAT(link.object_id SEPARATOR ', ') FROM process_link AS link  WHERE link.object_type LIKE '" + parameters[1] + "%' AND link.process_id=" + target + ".id  GROUP BY link.process_id ) AS object_ids ");
                                                                        }
                                                                        break block36;
                                                                    }
                                                                    if (!value.startsWith("status:")) break block55;
                                                                    String[] tokens = value.split(":");
                                                                    if (tokens.length < 3) {
                                                                        log.error("Incorrect column macros: " + value, new Object[0]);
                                                                        return;
                                                                    }
                                                                    statusList = tokens[1].trim();
                                                                    whatSelect = tokens[2].trim();
                                                                    statusString = statusList.replace(',', '_').replaceAll("\\s+", "");
                                                                    tableAlias = "ps_" + statusString + "_" + target;
                                                                    String joinQuery = " LEFT JOIN  process_status  AS " + tableAlias + " ON " + tableAlias + ".process_id=" + target + ".id AND " + tableAlias + ".status_id IN (" + statusList + ") AND " + tableAlias + ".last";
                                                                    if (joinPart.indexOf(joinQuery) < 0) {
                                                                        joinPart.append(joinQuery);
                                                                    }
                                                                    if (!whatSelect.startsWith("dt")) break block56;
                                                                    this.addDateTimeParam(selectPart, tableAlias + ".dt", Utils.substringAfter(value, ":", 2));
                                                                    break block36;
                                                                }
                                                                if (!"comment".equals(whatSelect)) break block57;
                                                                selectPart.append(" CONCAT(DATE_FORMAT( " + tableAlias + ".dt, '%d.%m.%y %T' ) ,' [', " + tableAlias + ".comment,']' ) ");
                                                                break block36;
                                                            }
                                                            if ("user".equals(whatSelect)) {
                                                                String tableUserAlias = "su_" + statusString;
                                                                joinPart.append(" LEFT JOIN  user  AS " + tableUserAlias + " ON " + tableAlias + ".user_id=" + tableUserAlias + ".id");
                                                                selectPart.append(tableUserAlias + ".title ");
                                                                break block36;
                                                            } else if ("dt_comment_all".equals(whatSelect)) {
                                                                selectPart.append(" ( SELECT GROUP_CONCAT( CONCAT(" + tableAlias + ".comment,' - ', CAST(" + tableAlias + ".dt AS CHAR)) SEPARATOR '; ')  FROM process_status AS " + tableAlias + " WHERE " + tableAlias + ".process_id=" + target + ".id AND " + tableAlias + ".status_id IN (" + statusList + ") ) ");
                                                            }
                                                            break block36;
                                                        }
                                                        if (!value.startsWith("message:")) break block58;
                                                        String[] tokens = value.split(":");
                                                        if (tokens.length < 3) {
                                                            log.error("Incorrect macros: " + value, new Object[0]);
                                                            return;
                                                        }
                                                        if ("systemId".equals(tokens[2])) {
                                                            String tableAlias = "messageSystemId";
                                                            joinPart.append(" LEFT JOIN  message  AS " + tableAlias + " ON " + tableAlias + ".process_id=" + target + ".id AND " + tableAlias + ".type_id IN (" + tokens[1] + ")");
                                                            selectPart.append(tableAlias + ".system_id");
                                                        }
                                                        break block36;
                                                    }
                                                    if (!value.startsWith("message")) break block59;
                                                    String joinQuery = " LEFT JOIN  process_message_state  AS pm_state ON " + target + ".id=pm_state.process_id  LEFT JOIN  message  AS pm_last_in ON pm_state.in_last_id=pm_last_in.id  LEFT JOIN  message  AS pm_last_out ON pm_state.out_last_id=pm_last_out.id  LEFT JOIN  user  AS pm_last_in_user ON pm_last_in.user_id=pm_last_in_user.id  LEFT JOIN  user  AS pm_last_out_user ON pm_last_out.user_id=pm_last_out_user.id";
                                                    if (joinPart.indexOf(joinQuery) < 0) {
                                                        joinPart.append(joinQuery);
                                                    }
                                                    if (!value.equals("messageInCount")) break block60;
                                                    selectPart.append(" pm_state.in_count ");
                                                    break block36;
                                                }
                                                if (!value.equals("messageInUnreadCount")) break block61;
                                                selectPart.append(" pm_state.in_unread_count ");
                                                break block36;
                                            }
                                            if (!value.startsWith("messageInLastDt")) break block62;
                                            this.addDateTimeParam(selectPart, "pm_state.in_last_dt", value);
                                            break block36;
                                        }
                                        if (!value.equals("messageInLastText")) break block63;
                                        selectPart.append(" pm_last_in.text ");
                                        break block36;
                                    }
                                    if (!value.equals("messageInLastSubject")) break block64;
                                    selectPart.append(" pm_last_in.subject ");
                                    break block36;
                                }
                                if (!value.equals("messageInLastUser")) break block65;
                                selectPart.append(" pm_last_in_user.title ");
                                break block36;
                            }
                            if (!value.equals("messageOutCount")) break block66;
                            selectPart.append(" pm_state.out_count ");
                            break block36;
                        }
                        if (!value.startsWith("messageOutLastDt")) break block67;
                        this.addDateTimeParam(selectPart, "pm_state.out_last_dt", value);
                        break block36;
                    }
                    if (!value.equals("messageOutLastText")) break block68;
                    selectPart.append(" pm_last_out.text ");
                    break block36;
                }
                if (value.equals("messageOutLastSubject")) {
                    selectPart.append(" pm_last_out.subject ");
                    break block36;
                } else if (value.equals("messageOutLastUser")) {
                    selectPart.append(" pm_last_out_user.title ");
                }
                break block36;
            }
            if (value.equals("title") || value.startsWith("executors") || value.startsWith("groups") || value.equals("actions") || value.startsWith("linkProcessList") || value.startsWith("linkedProcessList") || value.equals("N")) {
                selectPart.append("'0' ");
            } else {
                log.error("Incorrect column value macros: {}", value);
                selectPart.append("'0' ");
            }
        }
        selectPart.append(modifiers.getSecond());
        selectPart.append(", ");
    }

    private Pair<String, String> getModifiers() {
        String openTag = "";
        String closeTag = "";
        String type = this.getConvert();
        if ("int".equals(type)) {
            openTag = " CAST((";
            closeTag = ") AS UNSIGNED) ";
        }
        return new Pair<String, String>(openTag, closeTag);
    }

    private void addDateTimeParam(StringBuilder selectPart, String columnName, String value) {
        String format = StringUtils.substringAfter((String)value, (String)":");
        if (Utils.isBlankString(format) || format.equals("dt")) {
            selectPart.append(" DATE_FORMAT( ");
            selectPart.append(columnName);
            selectPart.append(", '%d.%m.%y %T' ) ");
        } else if (format.equals("value") || format.equals("nf")) {
            selectPart.append(columnName);
        } else {
            selectPart.append(" DATE_FORMAT( ");
            selectPart.append(columnName);
            selectPart.append(", '");
            selectPart.append(SQLUtils.javaDateFormatToSql(format));
            selectPart.append("' ) ");
        }
    }

    private String addProcessStatusJoin(String target, StringBuilder joinPart) {
        String alias = "ps_" + target + "_data";
        String joinQuery = " LEFT JOIN  process_status  AS " + alias + " ON " + target + ".id=" + alias + ".process_id AND " + target + ".status_id=" + alias + ".status_id AND " + alias + ".last";
        if (joinPart.indexOf(joinQuery) < 0) {
            joinPart.append(joinQuery);
        }
        return alias;
    }

    public Object getCellValue(DynActionForm form, boolean isHtmlMedia, Process process, Object rawCellValue) throws SQLException {
        List<Process> result = null;
        String columnValue = this.getValue();
        if (columnValue.equals("title")) {
            result = process.getTitle();
        } else if (columnValue.startsWith("executor")) {
            String[] tokens = columnValue.split(":");
            Set<Integer> allowedGroupIds = Collections.emptySet();
            Set<Integer> allowedRoleIds = Collections.emptySet();
            if (tokens.length > 1) {
                allowedGroupIds = Utils.toIntegerSet(tokens[1]);
            }
            if (tokens.length > 2) {
                allowedRoleIds = Utils.toIntegerSet(tokens[2]);
            }
            StringBuilder executors = new StringBuilder(50);
            Set<Integer> executorIds = process.getExecutorIds();
            Set<Integer> allowedGroupsExecutors = process.getExecutorIdsWithGroups(allowedGroupIds);
            Set<Integer> allowedRolesExecutors = process.getExecutorIdsWithRoles(allowedRoleIds);
            for (User user : UserCache.getUserList()) {
                if (!executorIds.contains(user.getId()) || allowedGroupIds.size() != 0 && !allowedGroupsExecutors.contains(user.getId()) || allowedRoleIds.size() != 0 && !allowedRolesExecutors.contains(user.getId())) continue;
                Utils.addSeparated(executors, ", ", user.getTitle());
            }
            result = executors.toString();
        } else if (columnValue.startsWith("groups")) {
            Set<Integer> allowedRoleIds = Utils.toIntegerSet(StringUtils.substringAfterLast((String)columnValue, (String)":"));
            StringBuilder groups = new StringBuilder(50);
            Set<Integer> groupIds = process.getGroupIds();
            Set<Integer> allowedRolesGroups = process.getGroupIdsWithRoles(allowedRoleIds);
            for (Group group : UserCache.getUserGroupList()) {
                if (!groupIds.contains(group.getId()) || allowedRoleIds.size() != 0 && !allowedRolesGroups.contains(group.getId())) continue;
                Utils.addSeparated(groups, ", ", group.getTitle());
            }
            result = groups.toString();
        } else if (columnValue.startsWith("linkProcessList") || columnValue.startsWith("linkedProcessList")) {
            String[] tokens = columnValue.split(":");
            String linkTypeFilter = tokens.length > 1 ? tokens[1] : "*";
            String stateFilter = tokens.length > 2 ? tokens[2] : "open";
            String typeFilter = tokens.length > 3 ? tokens[3] : "*";
            String linkTypeParam = linkTypeFilter.equals("*") ? null : linkTypeFilter;
            boolean stateParam = stateFilter.equals("open");
            Set<Integer> typeParam = typeFilter.equals("*") ? null : Utils.toIntegerSet(typeFilter);
            ProcessLinkDAO dao = new ProcessLinkDAO(form.getConnectionSet().getSlaveConnection(), form);
            result = columnValue.startsWith("linkProcessList") ? dao.getLinkProcessList(process.getId(), linkTypeParam, stateParam, typeParam) : dao.getLinkedProcessList(process.getId(), linkTypeParam, stateParam, typeParam);
        } else {
            result = isHtmlMedia ? rawCellValue : (columnValue.startsWith("linkObject:contract") ? String.valueOf(rawCellValue).replaceAll("\\w+:\\d+:", "") : String.valueOf(rawCellValue).replace("\n", " ").replace("\r", " "));
        }
        return result;
    }

    public String cellHtml(Process process, Object col) {
        return null;
    }
}

