/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bgcrm.util.Utils;

public class PhoneFormat {
    private final Map<Integer, List<String>> prefixMap;

    public PhoneFormat(String formats) {
        this.prefixMap = this.prefixMap(formats);
    }

    public String format(String value) {
        return this.phoneToFormat(value);
    }

    private Map<Integer, List<String>> prefixMap(String formats) {
        if (Utils.isEmptyString(formats)) {
            return null;
        }
        String[] prefixsArray = formats.split(",");
        HashMap<Integer, List<String>> prefixs = new HashMap<Integer, List<String>>();
        for (int i = 0; i < prefixsArray.length; ++i) {
            int countDigits = this.phoneUnformatted(prefixsArray[i]).length();
            ArrayList<String> list = (ArrayList<String>)prefixs.get(countDigits);
            if (list == null) {
                list = new ArrayList<String>();
                prefixs.put(countDigits, list);
            }
            list.add(prefixsArray[i]);
        }
        return prefixs;
    }

    private String phoneToFormat(String value) {
        if (this.prefixMap == null || this.prefixMap.isEmpty()) {
            return value;
        }
        String prefix = "";
        for (int i = value.length(); i >= 0; --i) {
            List<String> prefixsList = this.prefixMap.get(i);
            if (prefixsList == null) continue;
            String valueOnlyDigits = this.phoneUnformatted(value);
            for (String pref : prefixsList) {
                String prefixOnlyDigits = this.phoneUnformatted(pref);
                if (prefixOnlyDigits.length() > valueOnlyDigits.length() || !valueOnlyDigits.startsWith(prefixOnlyDigits)) continue;
                prefix = pref;
                break;
            }
            if (!Utils.isBlankString(prefix)) break;
        }
        if (Utils.isBlankString(prefix)) {
            return value;
        }
        if (value.length() > prefix.length()) {
            value = value.substring(0, prefix.length());
        }
        int posValue = 0;
        int posResult = 0;
        StringBuilder resValue = new StringBuilder();
        while (posResult < prefix.length() && posValue < value.length()) {
            if (Character.isDigit(prefix.charAt(posResult)) || prefix.charAt(posResult) == 'X') {
                resValue.append(value.charAt(posValue));
                ++posValue;
                ++posResult;
                continue;
            }
            resValue.append(prefix.charAt(posResult));
            ++posResult;
        }
        if (posValue < value.length()) {
            resValue.append(value.substring(posValue));
        }
        return resValue.toString();
    }

    private String phoneUnformatted(String phone) {
        if (Utils.isEmptyString(phone)) {
            return "";
        }
        StringBuilder sb = null;
        int size = phone.length();
        for (int i = 0; i < size; ++i) {
            char c = phone.charAt(i);
            if (Character.isDigit(c)) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb != null) continue;
            sb = new StringBuilder(phone.length());
            for (int j = 0; j < i; ++j) {
                sb.append(phone.charAt(j));
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return phone;
    }
}

