/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.message.process;

import java.util.List;
import java.util.TreeSet;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.dao.message.process.MessagePossibleProcessSearch;
import org.bgerp.model.process.link.ProcessLink;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;

@Bean
public class MessagePossibleProcessSearchFoundLinks
extends MessagePossibleProcessSearch {
    public MessagePossibleProcessSearchFoundLinks(int id, ConfigMap configMap) {
        super(id, configMap);
    }

    @Override
    public boolean addQuery(User user, PreparedQuery pq, boolean first, String from, List<ProcessLink> links, Boolean open) {
        if (links.isEmpty()) {
            return false;
        }
        if (!first) {
            pq.addQuery(" UNION ALL ");
        }
        TreeSet<Integer> objectIds = new TreeSet<Integer>();
        StringBuilder objectFilter = new StringBuilder();
        objectFilter.append("(0>1 ");
        for (CommonObjectLink commonObjectLink : links) {
            objectIds.add(commonObjectLink.getLinkObjectId());
            if ("customer".equals(commonObjectLink.getLinkObjectType())) {
                objectFilter.append(" OR (pl.object_type LIKE 'customer%' AND pl.object_id=" + commonObjectLink.getLinkObjectId() + ")");
                continue;
            }
            objectFilter.append(" OR (pl.object_type='" + commonObjectLink.getLinkObjectType() + "' AND pl.object_id=" + commonObjectLink.getLinkObjectId() + ")");
        }
        objectFilter.append(" ) ");
        pq.addQuery("SELECT p.*, ? AS type FROM  process AS p");
        pq.addInt(this.getId());
        pq.addQuery(" INNER JOIN  process_link ");
        pq.addQuery("AS pl ON pl.process_id=p.id AND pl.object_id IN (" + Utils.toString(objectIds) + ") AND ");
        pq.addQuery(objectFilter.toString());
        this.addOpenFilter(pq, open);
        return true;
    }
}

