/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.message.process;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.dao.message.process.MessagePossibleProcessSearch;
import org.bgerp.dao.message.process.MessagePossibleProcessSearchMessageFrom;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class MessagePossibleProcessConfig
extends Config {
    private static final Log log = Log.getLog();
    private final SortedMap<Integer, MessagePossibleProcessSearch> searches;

    protected MessagePossibleProcessConfig(ConfigMap config) throws Config.InitStopException {
        super(null);
        this.searches = this.parseSearches(config);
        this.initWhen(!this.searches.isEmpty());
    }

    private SortedMap<Integer, MessagePossibleProcessSearch> parseSearches(ConfigMap config) throws Config.InitStopException {
        TreeMap<Integer, MessagePossibleProcessSearch> result = new TreeMap<Integer, MessagePossibleProcessSearch>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("message.possible.process.").entrySet()) {
            ConfigMap searchConfigMap = me.getValue();
            String className = searchConfigMap.get("class");
            if (Utils.isBlankString(className)) continue;
            try {
                Class<?> clazz = Bean.getClass(className);
                MessagePossibleProcessSearch search = (MessagePossibleProcessSearch)clazz.getConstructor(Integer.TYPE, ConfigMap.class).newInstance(me.getKey(), me.getValue());
                result.put(me.getKey(), search);
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        if (result.isEmpty()) {
            result.put(1, new MessagePossibleProcessSearchMessageFrom(1, ConfigMap.EMPTY));
        }
        return Collections.unmodifiableSortedMap(result);
    }

    public SortedMap<Integer, MessagePossibleProcessSearch> getSearches() {
        return this.searches;
    }
}

