/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.custom.java;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGException;
import org.bgerp.custom.java.CompilationMessage;
import org.bgerp.custom.java.CompilationResult;
import org.bgerp.util.Log;
import ru.bgcrm.model.Pair;
import ru.bgcrm.util.Utils;

public class CompilerWrapper {
    private static final Log log = Log.getLog();
    private static final String DIR_PREFIX = "bgerp-";
    private final File srcDir;
    private final File outputDir;
    private static String classpath = null;

    public CompilerWrapper(File srcDir) {
        this.srcDir = srcDir;
        File outputDirRoot = new File(Utils.getTmpDir());
        this.removeOldTmpDirs(outputDirRoot);
        this.outputDir = new File(outputDirRoot, DIR_PREFIX + System.currentTimeMillis());
        this.outputDir.mkdir();
    }

    private void removeOldTmpDirs(File outputDirRoot) {
        try {
            for (File dir : outputDirRoot.listFiles(f -> f.isDirectory() && f.getName().startsWith(DIR_PREFIX))) {
                log.info("Removing: {}", dir);
                FileUtils.deleteDirectory((File)dir);
            }
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public Pair<CompilationResult, List<CompiledUnit>> compile(List<String> srcFiles) {
        String encoding = Setup.getSetup().get("custom.src.encoding", StandardCharsets.UTF_8.name());
        String[] options = Utils.notBlankString(encoding) ? new String[]{"-classpath", CompilerWrapper.getClasspath(), "-sourcepath", this.srcDir.getAbsolutePath(), "-encoding", encoding, "-d", this.outputDir.getAbsolutePath(), "-verbose", "-Xlint:deprecation"} : new String[]{"-classpath", CompilerWrapper.getClasspath(), "-sourcepath", this.srcDir.getAbsolutePath(), "-d", this.outputDir.getAbsolutePath(), "-verbose", "-Xlint:deprecation"};
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticListenerImpl listener = new DiagnosticListenerImpl(this);
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(listener, null, null);
        Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjectsFromStrings(srcFiles);
        StringWriter sw = new StringWriter();
        JavaCompiler.CompilationTask task = compiler.getTask(sw, fileManager, listener, Arrays.asList(options), null, fileObjects);
        boolean callResult = task.call();
        CompilationResult result = listener.getCompilationResult();
        result.setResult(callResult);
        return new Pair<CompilationResult, List<CompiledUnit>>(result, this.compiledFiles(this.outputDir));
    }

    private static String getClasspath() {
        String[] classpathEntries;
        if (classpath != null) {
            return classpath;
        }
        StringBuilder sb = new StringBuilder(300);
        for (String classPath : classpathEntries = System.getProperty("java.class.path").split(File.pathSeparator)) {
            sb.append(new File(classPath)).append(File.pathSeparator);
        }
        classpath = sb.toString();
        return classpath;
    }

    private List<CompiledUnit> compiledFiles(File directory) {
        ArrayList<CompiledUnit> result = new ArrayList<CompiledUnit>();
        for (File tmpdirFile : directory.listFiles()) {
            if (tmpdirFile.isFile()) {
                File compiledFile = tmpdirFile;
                String filePath = compiledFile.getAbsolutePath();
                String className = filePath.substring(this.outputDir.getAbsolutePath().length() + 1).replace(File.separatorChar, '.');
                className = className.substring(0, className.length() - 6);
                log.debug("Found compiled unit: {} with file {}", className, compiledFile);
                CompiledUnit unit = new CompiledUnit();
                unit.className = className;
                unit.classFile = compiledFile;
                unit.srcFile = this.getClassSrc(className);
                result.add(unit);
                continue;
            }
            if (!tmpdirFile.isDirectory()) continue;
            result.addAll(this.compiledFiles(tmpdirFile));
        }
        return result;
    }

    protected File getClassSrc(String className) {
        return null;
    }

    public void deleteClassDir() {
        if (this.outputDir != null && this.outputDir.exists()) {
            this.deleteDirWithFiles(this.outputDir);
        }
    }

    private void deleteDirWithFiles(File dir) {
        for (File tmpdirFile : dir.listFiles()) {
            if (tmpdirFile.isFile()) {
                tmpdirFile.delete();
                continue;
            }
            if (!tmpdirFile.isDirectory()) continue;
            this.deleteDirWithFiles(tmpdirFile);
        }
        dir.delete();
    }

    private class DiagnosticListenerImpl
    implements DiagnosticListener<JavaFileObject> {
        private CompilationResult result = new CompilationResult();

        private DiagnosticListenerImpl(CompilerWrapper compilerWrapper) {
        }

        private CompilationResult getCompilationResult() {
            return this.result;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            CompilationMessage message = new CompilationMessage();
            message.setMessage(diagnostic.getMessage(Locale.ENGLISH));
            message.setLine(diagnostic.getLineNumber());
            message.setColumn(diagnostic.getColumnNumber());
            message.setSource(diagnostic.getSource() != null ? diagnostic.getSource().getName() : null);
            switch (diagnostic.getKind()) {
                case ERROR: {
                    this.result.addError(message);
                    break;
                }
                case WARNING: 
                case MANDATORY_WARNING: {
                    this.result.addWarning(message);
                    break;
                }
                case NOTE: {
                    break;
                }
                case OTHER: {
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Code->" + diagnostic.getCode(), new Object[0]);
                log.debug("Column Number->" + diagnostic.getColumnNumber(), new Object[0]);
                log.debug("End Position->" + diagnostic.getEndPosition(), new Object[0]);
                log.debug("Kind->" + String.valueOf((Object)diagnostic.getKind()), new Object[0]);
                log.debug("Line Number->" + diagnostic.getLineNumber(), new Object[0]);
                log.debug("Message->" + diagnostic.getMessage(Locale.ENGLISH), new Object[0]);
                log.debug("Position->" + diagnostic.getPosition(), new Object[0]);
                log.debug("Source" + String.valueOf(diagnostic.getSource()), new Object[0]);
                log.debug("Start Position->" + diagnostic.getStartPosition(), new Object[0]);
            }
        }
    }

    public static class CompiledUnit {
        public String className;
        public File classFile;
        public File srcFile;
    }

    @Deprecated
    public static class CompilationFailedException
    extends BGException {
        private CompilationResult result;

        public CompilationResult getCompilationResult() {
            return this.result;
        }

        public CompilationFailedException(CompilationResult result) {
            this.result = result;
        }
    }
}

