/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.cache.Cache;
import org.bgerp.cache.CacheHolder;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.event.SetupChangedEvent;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class UserGroupRoleCache
extends Cache<UserGroupRoleCache> {
    private static final CacheHolder<UserGroupRoleCache> HOLDER = new CacheHolder<UserGroupRoleCache>(new UserGroupRoleCache());
    private Map<Integer, IdTitle> userGroupRoleMap;
    private List<IdTitle> userGroupRoleList;

    public static List<IdTitle> getUserGroupRoleList() {
        return UserGroupRoleCache.HOLDER.getInstance().userGroupRoleList;
    }

    public static Map<Integer, IdTitle> getUserGroupRoleMap() {
        return UserGroupRoleCache.HOLDER.getInstance().userGroupRoleMap;
    }

    @Override
    protected UserGroupRoleCache newInstance() {
        UserGroupRoleCache result = new UserGroupRoleCache();
        result.userGroupRoleList = Utils.parseIdTitleList(Setup.getSetup().get("processGroupRoles", "0:\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435"));
        result.userGroupRoleMap = new HashMap<Integer, IdTitle>(result.userGroupRoleList.size());
        for (IdTitle role : result.userGroupRoleList) {
            result.userGroupRoleMap.put(role.getId(), role);
        }
        return result;
    }

    static {
        EventProcessor.subscribe(new EventListener<SetupChangedEvent>(){

            @Override
            public void notify(SetupChangedEvent e, ConnectionSet connectionSet) {
                HOLDER.flush(connectionSet.getConnection());
            }
        }, SetupChangedEvent.class);
    }
}

