/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.exec.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.exec.scheduler.Task;
import org.bgerp.model.base.iface.IdTitle;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;

public class TaskConfig
implements IdTitle<String> {
    private static final Log log = Log.getLog();
    private static Set<Class<?>> runningClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String id;
    private final ConfigMap config;
    private final Class<? extends Task> clazz;
    private final String minute;
    private final String hour;
    private final String dayOfMonth;
    private final String month;
    private final String dayOfWeek;
    private final ExecutionTime executionTime;
    private final boolean enabled;
    private final AtomicBoolean running = new AtomicBoolean();
    private Date lastRunStart;
    private Duration lastRunDuration;

    TaskConfig(String id, ConfigMap config) throws Exception {
        this.id = id;
        this.config = config;
        this.clazz = Bean.getClass(config.get("class"));
        this.minute = config.get("minutes", "*");
        this.hour = config.get("hours", "*");
        this.dayOfMonth = config.get("dm", "*");
        this.month = config.get("month", "*");
        this.dayOfWeek = config.get("dw", "*");
        String expression = new StringBuilder(100).append(this.minute).append("\t").append(this.hour).append("\t").append(this.dayOfMonth).append("\t").append(this.month).append("\t").append(this.dayOfWeek).toString();
        Cron cron = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX)).parse(expression);
        this.executionTime = ExecutionTime.forCron((Cron)cron);
        this.enabled = config.getBoolean("enable", true);
        log.info("Class: {}; schedule: {}; enabled: {}", this.clazz.getName(), cron.asString(), this.enabled);
    }

    @Override
    @Dynamic
    public String getId() {
        return this.id;
    }

    @Override
    @Dynamic
    public String getTitle() {
        try {
            return this.taskInstance().getTitle();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Dynamic
    public String getMinute() {
        return this.minute;
    }

    @Dynamic
    public String getHour() {
        return this.hour;
    }

    @Dynamic
    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Dynamic
    public String getMonth() {
        return this.month;
    }

    @Dynamic
    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Dynamic
    public boolean isEnabled() {
        return this.enabled;
    }

    boolean checkTime(ZonedDateTime time) {
        return this.executionTime.isMatch(time);
    }

    Task taskInstance() throws Exception {
        try {
            return this.clazz.getDeclaredConstructor(ConfigMap.class).newInstance(this.config);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            throw e;
        }
        return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Dynamic
    public String getNotRunnableState() {
        if (this.running.get()) {
            return "Running task";
        }
        if (runningClasses.contains(this.clazz)) {
            return "Running class";
        }
        return null;
    }

    void taskRun() throws Exception {
        runningClasses.add(this.clazz);
        this.running.set(true);
        this.lastRunStart = new Date();
        this.taskInstance().run();
    }

    void taskDone() {
        runningClasses.remove(this.clazz);
        this.running.set(false);
        this.lastRunDuration = Duration.between(this.lastRunStart.toInstant(), Instant.now());
    }

    @Dynamic
    public Date getLastRunStart() {
        return this.lastRunStart;
    }

    @Dynamic
    public Duration getLastRunDuration() {
        return this.lastRunDuration;
    }

    public String toString() {
        return "Task " + this.clazz.getName();
    }
}

