/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.lic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.bgerp.app.dist.lic.License;
import org.bgerp.util.Log;

public class AppLicense {
    private static final Log log = Log.getLog();
    private static volatile License instance;

    public static void init() {
        File file = new File("lic.data");
        String data = "";
        if (file.exists() && file.canRead()) {
            log.info("Loading license from: {}", file);
            try (FileInputStream fis = new FileInputStream(file);){
                data = IOUtils.toString((InputStream)fis, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error(e);
            }
        } else {
            log.error("Empty license was initialized.", new Object[0]);
        }
        instance = new License(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static License instance() {
        Log log = AppLicense.log;
        synchronized (log) {
            if (instance == null || !instance.isCreatedToday()) {
                AppLicense.log.info("Re-init license, previous instance: {}", instance);
                AppLicense.init();
            }
        }
        return instance;
    }
}

