/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.cfg.bean;

import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.exception.BGException;
import org.bgerp.custom.Custom;
import org.bgerp.util.Log;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import ru.bgcrm.plugin.PluginManager;

public class Bean {
    private static final Log log = Log.getLog();
    private static volatile Map<String, Class<?>> beanClasses = Map.of();
    private static volatile Map<String, Class<?>> beanClassesOldNames = Map.of();

    public static final void loadBeanClasses() {
        log.debug("loadBeanClasses", new Object[0]);
        HashMap<String, Class> beanClasses = new HashMap<String, Class>(100);
        HashMap<String, Class> beanClassesOldNames = new HashMap<String, Class>(200);
        Reflections r = Bean.classes();
        for (Class clazz : r.getTypesAnnotatedWith(org.bgerp.app.cfg.bean.annotation.Bean.class, false)) {
            org.bgerp.app.cfg.bean.annotation.Bean an;
            String simpleName = clazz.getSimpleName();
            log.debug("Loading class: {}", clazz);
            beanClasses.put(clazz.getName(), clazz);
            Class beanClass = (Class)beanClasses.get(simpleName);
            if (beanClass != null) {
                log.error("Bean class simple name {} conflicts to an existing {}", clazz.getName(), beanClass.getName());
            } else {
                beanClasses.put(simpleName, clazz);
            }
            if ((an = clazz.getDeclaredAnnotation(org.bgerp.app.cfg.bean.annotation.Bean.class)) == null) continue;
            for (String name : an.oldClasses()) {
                beanClassesOldNames.put(name, clazz);
                simpleName = StringUtils.substringAfterLast((String)name, (String)".");
                beanClass = (Class)beanClassesOldNames.get(simpleName);
                if (beanClass != null) {
                    log.debug("Bean class OLD simple name {} conflicts to an existing {}", simpleName, beanClass.getName());
                    continue;
                }
                beanClassesOldNames.put(simpleName, clazz);
            }
        }
        Bean.beanClasses = Collections.unmodifiableMap(beanClasses);
        Bean.beanClassesOldNames = Collections.unmodifiableMap(beanClassesOldNames);
    }

    public static Reflections classes() {
        ConfigurationBuilder builder = new ConfigurationBuilder().forPackages(PluginManager.ERP_PACKAGES);
        URLClassLoader customClassLoader = Custom.INSTANCE.getClassLoader();
        if (customClassLoader != null) {
            log.debug("Adding custom classloader", new Object[0]);
            builder.addClassLoaders(new ClassLoader[]{customClassLoader}).forPackage("org.bgerp.plugin.custom", new ClassLoader[]{customClassLoader});
        }
        return new Reflections((Configuration)builder);
    }

    public static Class<?> getClass(String name) throws ClassNotFoundException {
        Class<?> result = beanClasses.get(name);
        if (result == null && (result = beanClassesOldNames.get(name)) != null) {
            log.warn("Bean class was found by an old name: {}", name);
        }
        if (result == null) {
            URLClassLoader customClassLoader = Custom.INSTANCE.getClassLoader();
            result = customClassLoader != null ? Class.forName(name, true, customClassLoader) : Class.forName(name);
        }
        return result;
    }

    public static final <T> T newInstance(String name) throws ClassNotFoundException {
        try {
            Class<?> clazz = Bean.getClass(name);
            if (clazz != null) {
                return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    static {
        Bean.loadBeanClasses();
    }
}

