/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.cfg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.MultilineContext;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.util.Log;
import ru.bgcrm.dao.ConfigDAO;
import ru.bgcrm.model.Config;
import ru.bgcrm.util.Utils;

public class Preferences
extends ConfigMap {
    private static final Log log = Log.getLog();
    private static final String INSTRUCTION_DELIM = ":";
    private static final String INSTRUCTION_INC = "inc";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{@([\\w\\.:]+)\\}");
    protected final ConcurrentHashMap<String, String> data = new ConcurrentHashMap();

    public Preferences() {
    }

    public Preferences(String data) {
        try {
            this.loadData(data, this.data, null, false);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    Preferences(String data, Iterable<String> includes, boolean validate) throws BGMessageException {
        this.loadData(data, this.data, includes, validate);
    }

    @Override
    public String get(String key, String def) {
        String result = this.data.get(key);
        return result != null ? result : def;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public String put(String key, String value) {
        this.clearConfigs();
        return this.data.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.data.putAll(m);
    }

    public Map<String, String> getDataMap() {
        return this.data;
    }

    public void removeSub(String prefix) {
        for (String key : this.data.keySet()) {
            if (!key.startsWith(prefix)) continue;
            this.data.remove(key);
        }
        this.clearConfigs();
    }

    protected void loadBundle(String bundleName, Map<String, String> data, boolean validate) {
        File file = new File(bundleName.replace('.', '/') + ".properties");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            MultilineContext context = new MultilineContext();
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.loadDataEntry(context, data, line.trim(), validate);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private void loadData(String conf, Map<String, String> data, Iterable<String> includes, boolean validate) throws BGMessageException {
        MultilineContext context = new MultilineContext();
        for (String line : Utils.maskNull(conf).split("\n")) {
            this.loadDataEntry(context, data, line.trim(), validate);
        }
        if (includes != null) {
            for (String include : includes) {
                this.loadData(include, data, null, validate);
            }
        }
    }

    private void loadDataEntry(MultilineContext context, Map<String, String> data, String line, boolean validate) throws BGMessageException {
        if ((line = line.replaceAll("\\p{C}+$", "")).startsWith("#")) {
            return;
        }
        if ((line = this.insertVariablesValues(line, data, validate)).equals(context.endOfLine)) {
            data.put(context.key, context.multiline.toString());
            context.endOfLine = null;
            context.multiline.setLength(0);
            return;
        }
        if (context.endOfLine != null) {
            context.multiline.append(line).append("\n");
            return;
        }
        int pos = line.indexOf("=");
        if (pos > 0) {
            if (line.charAt(pos - 1) == '+') {
                String key = line.substring(0, --pos);
                Object value = line.substring(pos + 2);
                if (data.containsKey(key)) {
                    value = data.get(key) + (String)value;
                }
                data.put(key, (String)value);
            } else {
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1);
                if (value.startsWith("<<")) {
                    context.key = key;
                    context.endOfLine = value.substring(MultilineContext.MULTILINE_PREFIX_LENGTH);
                    return;
                }
                data.put(key, value);
            }
        }
    }

    private String insertVariablesValues(String line, Map<String, String> data, boolean validate) throws BGMessageException {
        StringBuffer result = null;
        int pointer = 0;
        Matcher m = VARIABLE_PATTERN.matcher(line);
        while (m.find()) {
            String value;
            if (result == null) {
                result = new StringBuffer(line.length() + 16);
            }
            result.append(line.substring(pointer, m.start()));
            String variable = m.group(1);
            String[] tokens = variable.split(INSTRUCTION_DELIM);
            if (tokens.length == 2) {
                if (INSTRUCTION_INC.equals(tokens[0])) {
                    String val = data.get(tokens[1]);
                    if (val != null) {
                        data.put(tokens[1], String.valueOf(Utils.parseInt(val) + 1));
                    } else {
                        data.put(tokens[1], "1");
                    }
                    variable = tokens[1];
                } else if (validate) {
                    throw new BGMessageException("Unknown operation: " + tokens[0], new Object[0]);
                }
            }
            if ((value = data.get(variable)) != null) {
                result.append(value);
            } else {
                if (validate) {
                    throw new BGMessageException("Variable is not found: " + variable, new Object[0]);
                }
                result.append(m.group(0));
            }
            pointer = m.end();
        }
        if (result != null) {
            result.append(line.substring(pointer));
            return result.toString();
        }
        return line;
    }

    public static ConfigMap processIncludes(ConfigDAO configDao, String config, boolean validate) throws BGMessageException, SQLException {
        Iterable<String> includes = Config.getIncludes(configDao, new Preferences(config), validate);
        return new Preferences(config, includes, validate);
    }
}

