/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action.open;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.servlet.Interface;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.OldParamSearchDAO;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/open/profile")
public class ProfileAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/open/profile";

    public ActionForward show(DynActionForm form, ConnectionSet conSet) throws Exception {
        Config config = this.setup.getConfig(Config.class);
        if (config != null && config.isOpen(form.getId())) {
            form.setRequestAttribute("config", config);
            form.setResponseData("user", UserCache.getUser(form.getId()));
        }
        return this.html(conSet, form, "/WEB-INF/jspf/open/profile/show.jsp");
    }

    public static class Config
    extends org.bgerp.app.cfg.Config
    implements EventListener<ParamChangedEvent> {
        private static final Log log = Log.getLog();
        private final ConfigMap config;
        private final Parameter openParam;
        private final List<Integer> showParamIds;
        private final Set<Integer> shownUserIds;

        protected Config(ConfigMap config, boolean validate) throws Exception {
            super(null);
            this.config = config;
            int paramId = config.getInt("user.open.enable.paramId");
            this.initWhen(paramId > 0);
            this.openParam = ParameterCache.getParameter(paramId);
            this.showParamIds = Utils.toIntegerList(config.get("user.open.show.paramIds"));
            if (this.openParam == null) {
                this.throwValidationException("Param not found: {}", paramId);
            }
            if (!"list".equals(this.openParam.getType())) {
                this.throwValidationException("Param type of param {} must be 'list'", paramId);
            }
            if (this.showParamIds.isEmpty()) {
                this.throwValidationException("Param ID list is not defined.", new Object[0]);
            }
            try (Connection con = Setup.getSetup().getDBSlaveConnectionFromPool();){
                this.shownUserIds = new OldParamSearchDAO(con).searchObjectByParameterList(this.openParam.getId(), 1);
            }
            EventProcessor.subscribe(this, ParamChangedEvent.class);
        }

        public List<Integer> getShowParamIds() {
            return this.showParamIds;
        }

        public boolean isOpen(int userId) throws Exception {
            return this.shownUserIds.contains(userId);
        }

        @Dynamic
        public String url(int userId) {
            return Interface.getUrlOpen() + "/profile/" + userId;
        }

        @Override
        public void notify(ParamChangedEvent e, ConnectionSet conSet) throws Exception {
            if (e.getParameter().getId() != this.openParam.getId()) {
                return;
            }
            log.debug("Reset config", new Object[0]);
            EventProcessor.unsubscribe(this);
            this.config.removeConfig(this.getClass());
        }
    }
}

