/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action.open;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGSecurityException;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.dao.process.ProcessQueueDAO;
import org.bgerp.model.Pageable;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/open/process/queue")
public class ProcessQueueAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/open/process/queue";

    public ActionForward show(DynActionForm form, ConnectionSet conSet) throws Exception {
        int queueId = form.getId();
        Config config = this.setup.getConfig(Config.class);
        if (config == null || !config.isOpen(queueId)) {
            throw new BGSecurityException("Not opened queue was directly requested", form);
        }
        Queue queue = ProcessQueueCache.getQueue(queueId);
        if (queue == null) {
            throw new BGException("Queue not found: " + queueId, new Object[0]);
        }
        Pageable<Object[]> searchResult = new Pageable<Object[]>(form);
        searchResult.getPage().setPageIndex(Page.PAGE_INDEX_NO_PAGING);
        new ProcessQueueDAO(conSet.getSlaveConnection()).searchProcess(searchResult, null, queue, form);
        form.setRequestAttribute("columnList", queue.getMediaColumnList("html.open"));
        queue.replaceRowsForMedia(form, "html.open", searchResult.getList());
        form.setRequestAttribute("queue", queue);
        return this.html(conSet, null, "/WEB-INF/jspf/open/process/queue/show.jsp");
    }

    public static class Config
    extends org.bgerp.app.cfg.Config {
        private final Map<String, Queue> openQueues = this.loadOpenQueues();

        protected Config(ConfigMap setup) throws Exception {
            super(setup);
        }

        private Map<String, Queue> loadOpenQueues() throws Exception {
            HashMap<String, Queue> result = new HashMap<String, Queue>();
            for (Queue queue : ProcessQueueCache.getQueueList()) {
                String openUrl = queue.getOpenUrl();
                if (!Utils.notBlankString(openUrl)) continue;
                result.put(openUrl, queue);
            }
            return Collections.unmodifiableMap(result);
        }

        public boolean isOpen(int queueId) {
            return this.openQueues.values().stream().filter(q -> q.getId() == queueId).findFirst().isPresent();
        }

        public Integer getOpenQueueId(String openUrl) {
            Queue queue = this.openQueues.get(openUrl);
            return queue == null ? null : queue.getId();
        }
    }
}

