/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.dao.DemoDAO;
import org.bgerp.model.DemoEntity;
import org.bgerp.model.Pageable;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/demo", pathId=true)
public class DemoAction
extends org.bgerp.action.open.DemoAction {
    private static final Log log = Log.getLog();
    private static final String PATH_JSP = "/WEB-INF/jspf/user/demo";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) {
        super.unspecified(form, conSet);
        this.permTreesValues(form);
        return this.html(conSet, form, "/WEB-INF/jspf/user/demo/demo.jsp");
    }

    private void permTreesValues(DynActionForm form) {
        form.setRequestAttribute("permTrees", PermissionNode.getPermissionTrees());
    }

    public ActionForward enumValues(DynActionForm form, ConnectionSet conSet) {
        List<String> values = List.of("mail1@domain.com", "Ivan2 Pupkin <mail2@domain.com>", "Ivan3 Pupkin <mail3@domain.com>");
        form.setResponseData("values", values);
        return this.json(conSet, form);
    }

    public ActionForward tabContentFirst(DynActionForm form, ConnectionSet conSet) {
        form.setResponseData("content", "Tab content first");
        return this.html(conSet, form, "/WEB-INF/jspf/user/demo/tab.jsp");
    }

    public ActionForward tabContentSecond(DynActionForm form, ConnectionSet conSet) {
        form.setResponseData("content", "Tab content second");
        return this.html(conSet, form, "/WEB-INF/jspf/user/demo/tab.jsp");
    }

    public ActionForward formSend(DynActionForm form, ConnectionSet conSet) throws BGIllegalArgumentException {
        String title = form.getParam("title", Utils::notBlankString);
        form.setResponseData("messageTitle", "The form was successfully accepted");
        form.setResponseData("messageText", Log.format("The sent value was: <b>{}</b>", title));
        log.info("formSend was called, title: {}", title);
        return this.json(conSet, form);
    }

    public ActionForward entityList(DynActionForm form, Connection con) throws SQLException {
        String filter = form.getParam("filter");
        Pageable<DemoEntity> pageable = new Pageable<DemoEntity>(form, 5);
        new DemoDAO(con).search(pageable, filter);
        return this.html(con, form, "/WEB-INF/jspf/user/demo/entity/list.jsp");
    }

    public ActionForward entityGet(DynActionForm form, Connection con) throws Exception {
        if (form.getId() > 0) {
            DemoEntity entity = new DemoDAO(con).getOrThrow(form.getId());
            form.setResponseData("entity", entity);
        }
        Thread.sleep(Duration.ofSeconds(1L).toMillis());
        return this.html(con, form, "/WEB-INF/jspf/user/demo/entity/edit.jsp");
    }

    public ActionForward entityUpdate(DynActionForm form, Connection con) throws Exception {
        DemoEntity entity = new DemoEntity();
        entity.setId(form.getId());
        entity.setTitle(form.getParam("title", Utils::notBlankString));
        entity.setConfig(form.getParam("config"));
        new DemoDAO(con).update(entity);
        return this.json(con, form);
    }

    public ActionForward entityDelete(DynActionForm form, Connection con) throws Exception {
        new DemoDAO(con).delete(form.getId());
        Thread.sleep(Duration.ofSeconds(1L).toMillis());
        return this.json(con, form);
    }
}

