/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import java.util.ArrayList;
import java.util.List;
import org.bgerp.model.base.Id;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.proto.dao.BillingModuleDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.card.CardActivationData;
import ru.bgcrm.util.Utils;

public class CardDAO
extends BillingModuleDAO {
    private static final String CARD_MODULE_ID = "card";

    public CardDAO(User user, String billingId, int moduleId) {
        super(user, billingId, moduleId);
    }

    public CardDAO(User user, DBInfo dbInfo, int moduleId) {
        super(user, dbInfo.getId(), moduleId);
    }

    public List<IdTitle> CardContractInfo(int contractId, int serviceId, List<CardActivationData> activeCardList) {
        Object item;
        Request request = new Request();
        request.setModule(CARD_MODULE_ID);
        request.setAction("CardContractInfo");
        request.setModuleID(String.valueOf(this.moduleId));
        request.setContractId(contractId);
        request.setAttribute("list", "1");
        request.setAttribute("sid", serviceId);
        Document doc = this.transferData.postData(request, this.user);
        ArrayList<IdTitle> serviceList = new ArrayList<IdTitle>();
        for (Element el : XMLUtils.selectElements(doc, "/data/services/item")) {
            item = new IdTitle();
            ((Id)item).setId(Utils.parseInt(el.getAttribute("id")));
            ((IdTitle)item).setTitle(el.getAttribute("title"));
            serviceList.add((IdTitle)item);
        }
        activeCardList.clear();
        for (Element el : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            item = new CardActivationData();
            ((CardActivationData)item).setStatus(el.getAttribute("f0"));
            ((CardActivationData)item).setActivationDate(el.getAttribute("f1"));
            ((CardActivationData)item).setSumma(el.getAttribute("f2"));
            ((CardActivationData)item).setNumber(el.getAttribute("f3"));
            activeCardList.add((CardActivationData)item);
        }
        return serviceList;
    }

    public void activateCard(int contractId, String cardCode, String pinCode) {
        Request request = new Request();
        request.setModule(CARD_MODULE_ID);
        request.setModuleID(String.valueOf(this.moduleId));
        request.setAction("ActiveCard");
        request.setContractId(contractId);
        request.setAttribute("cardCode", cardCode.trim());
        request.setAttribute("cardPinCode", pinCode.trim());
        this.transferData.postData(request, this.user);
    }
}

