/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.dao;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bgerp.app.exception.BGException;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestToBilling;

public class BGBillingDAO
extends CommonDAO {
    private static final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, 50, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public BGBillingDAO() {
        super(null);
    }

    public Document doRequestToBilling(String dbKey, User user, Request request) throws BGException {
        Document result = null;
        DBInfoManager dBinfoManager = DBInfoManager.getInstance();
        DBInfo dBInfo = dBinfoManager.getDbInfoMap().get(dbKey);
        result = dBInfo != null ? dBInfo.getTransferData().postData(request, user) : this.createDocWithError("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430.");
        return result;
    }

    private Document createDocWithError(String error) {
        Document doc = XMLUtils.newDocument();
        Element rootNode = XMLUtils.newElement(doc, "data");
        rootNode.setAttribute("status", "error");
        XMLUtils.createTextNode(rootNode, error);
        return doc;
    }

    public Map<String, Document> doRequestToBilling(Collection<String> dBkeys, User user, Request req) {
        HashMap<String, Document> result = new HashMap<String, Document>(dBkeys.size());
        DBInfoManager dBinfoManager = DBInfoManager.getInstance();
        AtomicInteger taskCount = new AtomicInteger();
        try {
            for (String dBkey : dBkeys) {
                DBInfo dBInfo = dBinfoManager.getDbInfoMap().get(dBkey);
                if (dBInfo == null) continue;
                RequestToBilling requestToBilling = new RequestToBilling(taskCount, dBInfo.getTransferData(), dBkey, user, req, result);
                taskCount.incrementAndGet();
                threadPool.execute(requestToBilling);
            }
            while (taskCount.get() > 0) {
                Thread.sleep(300L);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return result;
    }
}

