/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.user.Permset;
import ru.bgcrm.util.Utils;

public class UserPermsetDAO
extends UserDAO {
    public UserPermsetDAO(Connection con) {
        super(con);
    }

    public void searchPermset(Pageable<Permset> searchResult) {
        this.searchPermset(searchResult, null);
    }

    public void searchPermset(Pageable<Permset> searchResult, String filterLike) {
        Page page = searchResult.getPage();
        try {
            List<Permset> list = searchResult.getList();
            PreparedQuery pq = new PreparedQuery(this.con);
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS  p.*, pp.permset_id FROM  user_permset_title  AS p ");
            pq.addQuery("LEFT JOIN  user_permset_permission  AS pp ON p.id=pp.permset_id ");
            if (Utils.notBlankString(filterLike)) {
                pq.addQuery("AND pp.config LIKE ? ");
                pq.addString(filterLike);
            }
            pq.addQuery(" GROUP BY p.id ");
            if (Utils.notBlankString(filterLike)) {
                pq.addQuery("HAVING title LIKE ? OR comment LIKE ? OR config LIKE ? OR pp.permset_id>0");
                pq.addString(filterLike);
                pq.addString(filterLike);
                pq.addString(filterLike);
            }
            pq.addQuery(" ORDER BY p.title");
            pq.addQuery(page.getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            if (page != null) {
                page.setRecordCount(pq.getPrepared());
            }
            pq.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public List<Permset> getPermsetList() {
        ArrayList<Permset> result = new ArrayList<Permset>();
        try {
            String query = "SELECT * FROM  user_permset_title  ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public Permset getPermsetById(int id) {
        Permset result = null;
        try {
            String query = "SELECT * FROM  user_permset_title  WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public void deletePermset(int id) throws SQLException {
        this.deleteById(" user_permset_title ", id);
    }

    private Permset getFromRS(ResultSet rs) throws SQLException {
        Permset result = new Permset();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setRoles(rs.getString("roles"));
        result.setComment(rs.getString("comment"));
        result.setConfig(rs.getString("config"));
        return result;
    }

    public void updatePermset(Permset userGroup) {
        int index = 1;
        try {
            PreparedStatement ps;
            if (userGroup.getId() <= 0) {
                ps = this.con.prepareStatement("INSERT INTO  user_permset_title  (title, roles, comment) VALUES (?,?,?)", 1);
                ps.setString(index++, userGroup.getTitle());
                ps.setString(index++, userGroup.getRoles());
                ps.setString(index++, userGroup.getComment());
                ps.executeUpdate();
                userGroup.setId(this.lastInsertId(ps));
            } else {
                ps = this.con.prepareStatement("UPDATE  user_permset_title  SET title=?,  roles=?, comment=?, config=? WHERE id=?");
                ps.setString(index++, userGroup.getTitle());
                ps.setString(index++, userGroup.getRoles());
                ps.setString(index++, userGroup.getComment());
                ps.setString(index++, userGroup.getConfig());
                ps.setInt(index++, userGroup.getId());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public Map<Integer, Map<String, ConfigMap>> getAllPermsets() throws SQLException {
        return this.getAllPermissions(" user_permset_permission ", "permset_id");
    }

    @Override
    public void updatePermissions(Set<String> action, Set<String> config, int permsetId) throws SQLException {
        this.updatePermissions(action, config, " user_permset_permission ", "permset_id", permsetId);
    }

    @Override
    public Map<String, ConfigMap> getPermissions(int permsetId) {
        try {
            String query = "SELECT * FROM  user_permset_permission  WHERE permset_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, permsetId);
            HashMap<String, ConfigMap> perms = new HashMap<String, ConfigMap>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String action = rs.getString("action");
                String config = rs.getString("config");
                perms.put(action, new Preferences(config));
            }
            ps.close();
            return perms;
        }
        catch (SQLException e) {
            throw new BGException();
        }
    }

    public void replacePermissions(int fromPermsetId, int toPermsetId) {
        try {
            String query = "DELETE FROM  user_permset_permission  WHERE permset_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, toPermsetId);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO  user_permset_permission  (permset_id, action, config) SELECT ?, action, config FROM  user_permset_permission WHERE permset_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, toPermsetId);
            ps.setInt(2, fromPermsetId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }
}

