/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.process;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.app.exception.BGException;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.util.sql.LikePattern;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonLinkDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class ProcessLinkDAO
extends CommonLinkDAO {
    private static final String LIKE_PROCESS = " LIKE 'process%'";
    private static final Set<String> CYCLES_CONTROL_LINK_TYPES = Set.of("processDepend", "processMade");
    protected final DynActionForm form;

    public ProcessLinkDAO(Connection con) {
        super(con);
        this.form = null;
    }

    public ProcessLinkDAO(Connection con, DynActionForm form) {
        super(con);
        this.form = form;
    }

    @Override
    protected String getTable() {
        return " process_link ";
    }

    @Override
    protected String getColumnName() {
        return "process_id";
    }

    @Override
    protected String getObjectType() {
        return "process";
    }

    public void linkToAnotherObject(int objectFromId, String typeObjectFrom, int objectToId, String typeObjectTo, String typePrefix, String excludeType) {
        try {
            StringBuilder query = new StringBuilder(200);
            query.append("INSERT IGNORE INTO ");
            query.append(" process_link ");
            query.append(" (process_id, object_id, object_type, object_title, config) ");
            query.append("SELECT process_id, ?, ?, object_title, config FROM ");
            query.append(" process_link ");
            query.append(" WHERE ");
            query.append("object_id=? AND object_type=?");
            if (Utils.notBlankString(typePrefix)) {
                query.append(" AND object_type LIKE '");
                query.append(typePrefix);
                query.append("%'");
            }
            if (Utils.notBlankString(excludeType)) {
                query.append(" AND object_type NOT LIKE '");
                query.append(excludeType);
                query.append("'");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, objectToId);
            ps.setString(2, typeObjectTo);
            ps.setInt(3, objectFromId);
            ps.setString(4, typeObjectFrom);
            ps.executeUpdate();
            ps.close();
            query = new StringBuilder(200);
            query.append("DELETE FROM ");
            query.append(" process_link ");
            query.append(" WHERE ");
            query.append("object_id=? AND object_type=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, objectFromId);
            ps.setString(2, typeObjectFrom);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public List<Process> getLinkProcessList(int processId, String linkType, boolean onlyOpen, Set<Integer> typeIds) throws SQLException {
        return this.getFromLinkProcess(processId, linkType, onlyOpen, "INNER JOIN  process_link  AS link ON process.id=link.object_id AND link.object_type  LIKE 'process%' AND link.process_id=? ", typeIds);
    }

    public List<Process> getLinkedProcessList(int processId, String linkType, boolean onlyOpen, Set<Integer> typeIds) throws SQLException {
        return this.getFromLinkProcess(processId, linkType, onlyOpen, "INNER JOIN  process_link  AS link ON process.id=link.process_id AND link.object_type  LIKE 'process%' AND link.object_id=? ", typeIds);
    }

    private List<Process> getFromLinkProcess(int processId, String linkType, boolean onlyOpen, String joinQuery, Set<Integer> typeIds) throws SQLException {
        ArrayList<Process> result = new ArrayList<Process>();
        PreparedQuery pq = new PreparedQuery(this.con);
        pq.addQuery("SELECT process.* FROM  process  AS process ");
        pq.addQuery(joinQuery);
        pq.addQuery(ProcessDAO.getIsolationJoin(this.form, "process"));
        pq.addInt(processId);
        pq.addQuery("WHERE 1>0 ");
        if (CollectionUtils.isNotEmpty(typeIds)) {
            pq.addQuery("AND process.type_id IN (" + Utils.toString(typeIds) + ")");
        }
        if (Utils.notBlankString(linkType)) {
            pq.addQuery("AND link.object_type=?");
            pq.addString(linkType);
        }
        if (onlyOpen) {
            pq.addQuery("AND process.close_dt IS NULL ");
        }
        pq.addQuery("ORDER BY process.create_dt");
        ResultSet rs = pq.executeQuery();
        while (rs.next()) {
            result.add(ProcessDAO.getProcessFromRs(rs));
        }
        pq.close();
        return result;
    }

    public Collection<CommonObjectLink> getLinksOver(Set<Integer> processIds) throws SQLException {
        ArrayList<CommonObjectLink> result = new ArrayList<CommonObjectLink>(processIds.size());
        if (processIds.isEmpty()) {
            return result;
        }
        String ids = Utils.toString(processIds);
        StringBuilder query = new StringBuilder(ids.length() * 2 + 300);
        query.append("SELECT * FROM  process_link  AS link ");
        query.append("WHERE process_id IN (");
        query.append(ids);
        query.append(") AND object_id IN (");
        query.append(ids);
        query.append(") AND link.object_type  LIKE 'process%'");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            CommonObjectLink link = new CommonObjectLink();
            link.setObjectId(rs.getInt("process_id"));
            link.setLinkObjectType(rs.getString("object_type"));
            link.setLinkObjectId(rs.getInt("object_id"));
            result.add(link);
        }
        ps.close();
        return result;
    }

    public boolean checkCycles(int processId) throws Exception {
        HashMap<String, Set<Integer>> typeProcessIds = new HashMap<String, Set<Integer>>(CYCLES_CONTROL_LINK_TYPES.size());
        for (String linkType : CYCLES_CONTROL_LINK_TYPES) {
            typeProcessIds.put(linkType, Sets.newHashSet((Object[])new Integer[]{processId}));
        }
        Map<String, Set<Integer>> generationTypeProcessIds = typeProcessIds;
        do {
            generationTypeProcessIds = this.getLinkProcessIds(generationTypeProcessIds);
            for (String linkType : CYCLES_CONTROL_LINK_TYPES) {
                Set<Integer> generationProcessIds = generationTypeProcessIds.get(linkType);
                if (generationProcessIds == null) continue;
                Set processIds = (Set)typeProcessIds.get(linkType);
                if (!CollectionUtils.intersection((Iterable)processIds, generationProcessIds).isEmpty()) {
                    return true;
                }
                processIds.addAll(generationProcessIds);
            }
        } while (generationTypeProcessIds.size() > 0);
        return false;
    }

    private Map<String, Set<Integer>> getLinkProcessIds(Map<String, Set<Integer>> typeProcessIds) throws Exception {
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>(typeProcessIds.size());
        Set<Object> processIds = typeProcessIds.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Statement st = this.con.createStatement();
        String query = "SELECT process_id, object_type, object_id FROM  process_link  WHERE process_id IN (" + Utils.toString(processIds) + ") AND object_type  LIKE 'process%'";
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            int processId = rs.getInt(1);
            String type = rs.getString(2);
            processIds = typeProcessIds.get(type);
            if (processIds == null || !processIds.contains(processId)) continue;
            result.computeIfAbsent(type, t -> new HashSet()).add(rs.getInt(3));
        }
        st.close();
        this.log.debug("getLinkProcessIds {} => {}", typeProcessIds, result);
        return result;
    }

    public Set<Customer> getLinkCustomers(int processId, String linkObjectType) throws SQLException {
        TreeSet<Customer> result = new TreeSet<Customer>();
        if (Utils.isBlankString(linkObjectType)) {
            linkObjectType = LikePattern.START.get("customer");
        }
        String query = "SELECT c.* FROM  customer AS c INNER JOIN  process_link AS pl ON c.id=pl.object_id AND pl.process_id=? AND pl.object_type LIKE ?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(processId);
            pq.addString(linkObjectType);
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.add(CustomerDAO.getCustomerFromRs(rs, ""));
            }
        }
        return result;
    }

    public Pair<Integer, Integer> getLinkedProcessesCounts(int processId) throws SQLException {
        Pair<Integer, Integer> result = new Pair<Integer, Integer>(0, 0);
        String query = "SELECT COUNT(*) FROM  process_link AS linked  WHERE linked.object_id=? AND linked.object_type  LIKE 'process%' UNION ALL SELECT COUNT(*) FROM  process_link AS link WHERE link.process_id=? AND link.object_type  LIKE 'process%'";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(processId).addInt(processId);
            ResultSet rs = pq.executeQuery();
            if (rs.next()) {
                result.setFirst(rs.getInt(1));
            }
            if (rs.next()) {
                result.setSecond(rs.getInt(1));
            }
        }
        return result;
    }

    @Deprecated
    public Set<Integer> getLinkedProcessTypeIdList(String objectType, int objectId) throws SQLException {
        TreeSet<Integer> list = new TreeSet<Integer>();
        Object query = "SELECT DISTINCT process.type_id FROM  process  AS process INNER JOIN  process_link  AS link ON process.id=link.process_id  AND link.object_id=? AND link.object_type LIKE ? ";
        query = (String)query + "ORDER BY process.type_id";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setInt(1, objectId);
            ps.setString(2, objectType);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(Utils.parseInt(rs.getString(1)));
            }
        }
        return list;
    }
}

