/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

public class PreparedQuery
implements AutoCloseable {
    private static final Log log = Log.getLog();
    private Connection con;
    private StringBuilder query;
    private List<Object> parameters = new ArrayList<Object>(20);
    private PreparedStatement ps;

    public PreparedQuery(Connection con) {
        this.con = con;
    }

    public PreparedQuery(Connection con, String query) {
        this.con = con;
        this.addQuery(query);
    }

    public PreparedStatement getPrepared() {
        return this.ps;
    }

    @Deprecated
    public StringBuilder getQuery() {
        return this.query;
    }

    public PreparedQuery addQuery(String value) {
        if (Utils.isBlankString(value)) {
            return this;
        }
        if (this.query == null) {
            this.query = new StringBuilder();
        }
        this.query.append(value);
        return this;
    }

    public void setQuery(String value) {
        this.query.setLength(0);
        this.query.append(value);
    }

    public void setPos(int pos) throws SQLException {
        this.parameters = this.parameters.subList(0, pos);
        if (this.ps != null) {
            this.ps.close();
        }
        this.ps = null;
    }

    public PreparedQuery addInt(int value) {
        this.parameters.add(value);
        return this;
    }

    public PreparedQuery addLong(long value) {
        this.parameters.add(value);
        return this;
    }

    public PreparedQuery addBigDecimal(BigDecimal value) {
        this.parameters.add(value);
        return this;
    }

    public PreparedQuery addString(String value) {
        this.parameters.add(value);
        return this;
    }

    public PreparedQuery addDate(Date value) {
        this.parameters.add(TimeUtils.convertDateToSqlDate(value));
        return this;
    }

    public PreparedQuery addTimestamp(Timestamp value) {
        this.parameters.add(value);
        return this;
    }

    public PreparedQuery addTimestamp(Date value) {
        this.parameters.add(TimeConvert.toTimestamp(value));
        return this;
    }

    public PreparedQuery addBoolean(Boolean value) {
        this.parameters.add(value);
        return this;
    }

    public PreparedQuery addObjects(Object ... values) {
        for (Object value : values) {
            this.parameters.add(value);
        }
        return this;
    }

    public ResultSet executeQuery() throws SQLException {
        this.prepareStatementAndSetParameters();
        return this.ps.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        this.prepareStatementAndSetParameters();
        return this.ps.executeUpdate();
    }

    public int executeInsert() throws SQLException {
        if (this.ps == null) {
            this.ps = this.con.prepareStatement(this.query.toString(), 1);
            this.setParameters();
        }
        this.ps.executeUpdate();
        return SQLUtils.lastInsertId(this.ps);
    }

    private void prepareStatementAndSetParameters() throws SQLException {
        if (this.ps == null) {
            this.ps = this.con.prepareStatement(this.query.toString());
        }
        this.setParameters();
        log.debug("Q: {}", this.ps);
    }

    private void setParameters() throws SQLException {
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            this.ps.setObject(i + 1, this.parameters.get(i));
        }
    }

    @Override
    public void close() {
        try {
            if (this.ps != null) {
                this.ps.close();
            }
            this.ps = null;
            this.parameters.clear();
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public String toString() {
        return Log.format("Prepared query: {}, params: {}", this.query, this.parameters);
    }
}

