/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl.dao;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.plugin.pln.grpl.model.BoardConfig;
import org.bgerp.plugin.pln.grpl.model.Cell;
import org.bgerp.plugin.pln.grpl.model.Row;
import org.bgerp.plugin.pln.grpl.model.Slot;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.util.TimeUtils;

public class GrplDAO
extends CommonDAO {
    public GrplDAO(Connection con) {
        super(con);
    }

    public List<Row> getRows(BoardConfig board, java.util.Date dateFrom, java.util.Date dateTo) throws SQLException {
        ResultSet rs;
        TreeMap<java.util.Date, Row> result = new TreeMap<java.util.Date, Row>();
        String query = "SELECT bg.date, bg.column_id, bg.group_id, p.*, bp.time, bp.duration FROM  grpl_board_group AS bg LEFT JOIN  grpl_board_process AS bp ON bg.board_id=bp.board_id AND bg.date=bp.date AND bg.column_id=bp.column_id LEFT JOIN  process AS p ON bp.process_id=p.id WHERE bg.board_id=? AND ?<=bg.date AND bg.date<=? ORDER BY date, time IS NULL, time";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(board.getId());
            pq.addDate(dateFrom);
            pq.addDate(dateTo);
            Row row = null;
            rs = pq.executeQuery();
            while (rs.next()) {
                int processId;
                Date date2 = rs.getDate("date");
                if (row == null || !row.getDate().equals(date2)) {
                    row = new Row(board, date2);
                    result.put(row.getDate(), row);
                }
                int columnId = rs.getInt("column_id");
                int groupId = rs.getInt("group_id");
                if (columnId <= 0 || groupId <= 0) continue;
                Cell cell = row.getCell(columnId);
                if (cell == null) {
                    cell = row.setCell(columnId, groupId);
                }
                if ((processId = rs.getInt("p.id")) <= 0) continue;
                cell.getSlots().add(new Slot(cell, ProcessDAO.getProcessFromRs(rs, "p."), rs));
            }
        }
        while (!dateFrom.after(dateTo)) {
            result.computeIfAbsent(dateFrom, date -> new Row(board, (java.util.Date)date));
            dateFrom = TimeUtils.getNextDay(dateFrom);
        }
        Row row = new Row(board, (java.util.Date)null);
        query = "SELECT bp.column_id, bp.duration, bp.time, p.* FROM  grpl_board_process AS bp LEFT JOIN  process AS p ON bp.process_id=p.id WHERE bp.board_id=? AND bp.date IS NULL";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(board.getId());
            rs = pq.executeQuery();
            while (rs.next()) {
                int columnId = rs.getInt("column_id");
                Cell cell = row.getCell(columnId);
                if (cell == null) {
                    cell = row.setCell(columnId, 0);
                }
                cell.getSlots().add(new Slot(cell, ProcessDAO.getProcessFromRs(rs, "p."), rs));
            }
        }
        return row.hasCells() ? Stream.concat(result.values().stream(), Stream.of(row)).toList() : result.values().stream().toList();
    }

    public Row getRow(BoardConfig board, java.util.Date date) throws SQLException {
        Row result = new Row(board, date);
        String query = "SELECT * FROM  grpl_board_group  WHERE board_id=? AND date=?";
        try (PreparedQuery pq = new PreparedQuery(this.con, query);){
            pq.addInt(board.getId());
            pq.addDate(date);
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                result.setCell(rs.getInt("column_id"), rs.getInt("group_id"));
            }
        }
        return result;
    }

    public void updateGroup(int boardId, java.util.Date date, int columnId, int groupId) throws SQLException {
        if (groupId > 0) {
            this.updateOrInsert("UPDATE  grpl_board_group SET group_id=? WHERE board_id=? AND date=? AND column_id=?", "INSERT INTO  grpl_board_group (group_id, board_id, date, column_id) VALUES (?,?,?,?)", groupId, boardId, date, columnId);
        } else {
            try (PreparedQuery pq = new PreparedQuery(this.con, "DELETE FROM  grpl_board_group  WHERE board_id=? AND date=? AND column_id=?");){
                pq.addInt(boardId);
                pq.addDate(date);
                pq.addInt(columnId);
                pq.executeUpdate();
            }
        }
    }

    public Slot getSlot(BoardConfig board, Process process) throws SQLException {
        Slot result = null;
        try (PreparedQuery pq = new PreparedQuery(this.con, "SELECT bp.column_id, bp.duration, bp.date, bp.time, bg.group_id FROM  grpl_board_process AS bp LEFT JOIN  grpl_board_group AS bg ON bp.board_id=bg.board_id AND bp.column_id=bg.column_id AND bp.date=bg.date WHERE bp.board_id=? AND bp.process_id=?");){
            pq.addInt(board.getId());
            pq.addInt(process.getId());
            ResultSet rs = pq.executeQuery();
            if (rs.next()) {
                Row row = new Row(board, rs);
                Cell cell = row.setCell(rs.getInt("column_id"), rs.getInt("group_id"));
                result = new Slot(cell, process, rs);
            }
        }
        return result;
    }

    public void updateSlot(BoardConfig board, Process process, int columnId, Duration duration) throws SQLException {
        this.updateOrInsert("UPDATE  grpl_board_process  SET column_id=?, duration=? WHERE board_id=? AND process_id=?", "INSERT INTO  grpl_board_process (column_id, duration, board_id, process_id) VALUES (?,?,?,?)", columnId, duration.toMinutes(), board.getId(), process.getId());
    }

    public void updateSlotTime(BoardConfig board, Process process, java.util.Date date, LocalTime time) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con, "UPDATE  grpl_board_process  SET date=?, time=? WHERE board_id=? AND process_id=?");){
            pq.addObjects(date, time, board.getId(), process.getId());
            pq.executeUpdate();
        }
        this.updateProcessGroups(board, process);
    }

    private void updateProcessGroups(BoardConfig board, Process process) throws SQLException {
        Slot slot = this.getSlot(board, process);
        ProcessGroups groups = process.getGroups();
        Set<ProcessGroup> groupsBefore = Collections.unmodifiableSet(new ProcessGroups(groups));
        groups.removeIf(pg -> board.getGroupIds().contains(pg.getGroupId()));
        Group group = slot.getCell().getGroup();
        if (group != null) {
            groups.add(new ProcessGroup(group.getId()));
        }
        if (!CollectionUtils.isEqualCollection(groupsBefore, (Collection)groups)) {
            new ProcessDAO(this.con).updateProcessGroups(groups, process.getId());
        }
    }

    public void deleteProcess(int processId) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con, "DELETE FROM  grpl_board_process  WHERE process_id=?");){
            pq.addInt(processId);
            pq.executeUpdate();
        }
    }
}

