/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.subscription.model.config;

import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.plugin.msg.email.message.MessageTypeEmail;
import ru.bgcrm.util.Utils;

public class PaidInvoiceConfig
extends Config {
    private final String dateToExpression;
    private final MessageTypeEmail emailMessageType;
    private final String emailSubject;
    private final String emailTextExpression;

    protected PaidInvoiceConfig(ConfigMap config) throws Config.InitStopException {
        super(null);
        config = config.sub("paid.invoice.");
        this.dateToExpression = config.get("dateTo.expression");
        this.emailMessageType = this.loadOnPaidInvoiceEmailMessageType(config.getInt("email.message.type", -1));
        this.emailSubject = config.get("email.subject", "BGERP License");
        this.emailTextExpression = config.get("email.text.expression", "\"As an attachment you will find a new license file.\"");
        this.initWhen(Utils.notBlankString(this.dateToExpression));
    }

    private MessageTypeEmail loadOnPaidInvoiceEmailMessageType(int id) {
        MessageTypeEmail result = null;
        MessageTypeConfig messageTypesConfig = Setup.getSetup().getConfig(MessageTypeConfig.class);
        if (id == 0) {
            result = messageTypesConfig.getMessageType(MessageTypeEmail.class);
        } else if (id > 0) {
            result = (MessageTypeEmail)messageTypesConfig.getTypeMap().get(id);
        }
        return result;
    }

    public String getDateToExpression() {
        return this.dateToExpression;
    }

    public MessageTypeEmail getEmailMessageType() {
        return this.emailMessageType;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getEmailTextExpression() {
        return this.emailTextExpression;
    }
}

