/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bgerp.app.servlet.user.LoginStat;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.User;

public class Maintenance {
    private static final Log log = Log.getLog();
    private static volatile Maintenance instance;
    private final ScheduledFuture<?> scheduledFuture;
    private final User user;
    private final LocalDateTime startTime = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    private final LocalDateTime logoffTime;

    public static Maintenance instance() {
        return instance;
    }

    public static Maintenance start(User user, Duration logoffDelay) {
        if (instance != null) {
            throw new IllegalStateException("Maintenance is already running");
        }
        log.info("Started by: {}, logoff delay: {}", user.getTitle(), logoffDelay);
        instance = new Maintenance(user, logoffDelay);
        return instance;
    }

    public static Maintenance cancel() {
        log.info("Cancel", new Object[0]);
        if (instance != null) {
            Maintenance.instance.scheduledFuture.cancel(false);
        }
        Maintenance result = instance;
        instance = null;
        return result;
    }

    private Maintenance(User user, Duration logoffDelay) {
        this.user = user;
        this.logoffTime = this.startTime.plus(logoffDelay);
        this.scheduledFuture = this.schedule(logoffDelay);
    }

    private ScheduledFuture<?> schedule(Duration logoffDelay) {
        return Executors.newScheduledThreadPool(1).schedule(() -> {
            log.info("Logging user sessions off", new Object[0]);
            LoginStat.instance().loggedUsersWithSessions().values().stream().flatMap(Collection::stream).filter(session -> session.getUser().getId() != this.user.getId()).forEach(session -> session.getSession().invalidate());
        }, logoffDelay.toSeconds(), TimeUnit.SECONDS);
    }

    public User getUser() {
        return this.user;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getLogoffTime() {
        return this.logoffTime;
    }
}

