/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action.base;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.action.base.BaseAction;
import org.reflections.Reflections;
import ru.bgcrm.plugin.Plugin;
import ru.bgcrm.servlet.ActionServlet;

public class Actions {
    private static final Map<String, Action> ACTIONS_BY_ID = new ConcurrentHashMap<String, Action>();
    private static final Map<Class<? extends BaseAction>, Action> ACTIONS_BY_CLASS = new ConcurrentHashMap<Class<? extends BaseAction>, Action>();

    public static void init(Iterable<Plugin> plugins) {
        ACTIONS_BY_ID.clear();
        ACTIONS_BY_CLASS.clear();
        for (Plugin p : plugins) {
            Reflections r = new Reflections(new Object[]{p.getActionPackages()});
            for (Class ac : r.getSubTypesOf(BaseAction.class)) {
                ActionServlet.Action a = ac.getDeclaredAnnotation(ActionServlet.Action.class);
                if (a == null) continue;
                Action action = new Action(a, ac);
                ACTIONS_BY_ID.put(action.getId(), action);
                ACTIONS_BY_CLASS.put(ac, action);
            }
        }
    }

    public static Action getById(String id) {
        return ACTIONS_BY_ID.get(id);
    }

    public static Action getByClass(Class<? extends BaseAction> clazz) {
        return ACTIONS_BY_CLASS.get(clazz);
    }

    public static Collection<Action> actions() {
        return ACTIONS_BY_ID.values();
    }

    public static class Action {
        private final String path;
        private final String type;
        private final Class<? extends BaseAction> typeClass;
        private final String id;

        private Action(ActionServlet.Action action, Class<? extends BaseAction> clazz) {
            this.path = action.path();
            this.type = clazz.getCanonicalName();
            this.typeClass = clazz;
            this.id = action.pathId() ? this.path : this.type;
        }

        public String getPath() {
            return this.path;
        }

        public String getType() {
            return this.type;
        }

        public Class<? extends BaseAction> getTypeClass() {
            return this.typeClass;
        }

        public String getId() {
            return this.id;
        }
    }
}

