/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.model.inet;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bgerp.model.base.tree.TreeItem;
import ru.bgcrm.plugin.bgbilling.proto.model.inet.InetUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.inet.IPUtils;
import ru.bgcrm.util.inet.IpNet;

public class InetService
extends TreeItem<Integer, InetService> {
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_CLOSED = 1;
    @Deprecated
    public static final int STATUS_LOCKED = 2;
    public static final short STATE_NULL = -1000;
    public static final short STATE_DELETED = -1;
    public static final short STATE_DISABLE = 0;
    public static final short STATE_ENABLE = 1;
    private int contractId;
    private int typeId;
    private String typeTitle;
    private String login;
    private int deviceId;
    private String deviceTitle;
    private int ipResId;
    private byte[] addrFrom;
    private byte[] addrTo;
    private List<byte[]> macAddressList;
    private int contractObjectId;
    private int ifaceId;
    private String interfaceTitle;
    private int vlan = -1;
    private int status;
    private int sessionCountLimit;
    private Date dateFrom;
    private Date dateTo;
    private short devState;
    private int accessCode;
    private String accessCodeTitle;
    private String comment;
    private String password;

    @JsonProperty(value="passw")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getContractId() {
        return this.contractId;
    }

    public int getCid() {
        return this.getContractId();
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public String getTypeTitle() {
        return this.typeTitle;
    }

    public void setTypeTitle(String typeTitle) {
        this.typeTitle = typeTitle;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getUname() {
        return this.getLogin();
    }

    public void setUname(String login) {
        this.setLogin(login);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public int getDid() {
        return this.getDeviceId();
    }

    public void setDid(int deviceId) {
        this.setDeviceId(deviceId);
    }

    public String getDeviceTitle() {
        return this.deviceTitle;
    }

    public void setDeviceTitle(String deviceTitle) {
        this.deviceTitle = deviceTitle;
    }

    public int getIpResId() {
        return this.ipResId;
    }

    public void setIpResId(int ipResourceId) {
        this.ipResId = ipResourceId;
    }

    public byte[] getAddrFrom() {
        return this.addrFrom;
    }

    public void setAddrFrom(byte[] addrFrom) {
        this.addrFrom = addrFrom;
    }

    public byte[] getAddrTo() {
        return this.addrTo;
    }

    public void setAddrTo(byte[] addrTo) {
        this.addrTo = addrTo;
    }

    public String getAddrFromStr() {
        return IPUtils.convertIpToString(IPUtils.convertBytesToInt(this.addrFrom));
    }

    public String getAddrToStr() {
        return IPUtils.convertIpToString(IPUtils.convertBytesToInt(this.addrTo));
    }

    public int getMask() {
        return this.addrFrom == null || this.addrTo == null ? 0 : IpNet.getMask(this.addrFrom, this.addrTo);
    }

    public int getIfaceId() {
        return this.ifaceId;
    }

    public void setIfaceId(int ifaceId) {
        this.ifaceId = ifaceId;
    }

    public String getInterfaceTitle() {
        return this.interfaceTitle;
    }

    public void setInterfaceTitle(String interfaceTitle) {
        this.interfaceTitle = interfaceTitle;
    }

    public byte[] getMacAddress() {
        return Utils.getFirst(this.macAddressList);
    }

    public void setMacAddress(byte[] macAddress) {
        this.setMacAddressList(Collections.singletonList(macAddress));
    }

    public String getMacAddressStr() {
        return InetUtils.macAddressToString(Utils.getFirst(this.macAddressList));
    }

    public void setMacAddressStr(String macAddress) {
        this.setMacAddressList(Collections.singletonList(InetUtils.parseMacAddress(macAddress)));
        if (!this.macAddressList.isEmpty() && this.macAddressList.get(0) == null) {
            this.macAddressList = null;
        }
    }

    public List<byte[]> getMacAddressList() {
        return this.macAddressList;
    }

    public void setMacAddressList(List<byte[]> macAddress) {
        this.macAddressList = macAddress;
    }

    public int getVlan() {
        return this.vlan;
    }

    public void setVlan(int vlan) {
        this.vlan = vlan;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getStatusTitle() {
        if ((Integer)this.parentId > 0) {
            return "";
        }
        switch (this.status) {
            case 0: {
                return "\u043e\u0442\u043a\u0440\u044b\u0442";
            }
            case 1: {
                return "\u0437\u0430\u043a\u0440\u044b\u0442";
            }
            case 2: {
                return "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
            }
        }
        return "---";
    }

    public int getSessionCountLimit() {
        return this.sessionCountLimit;
    }

    public void setSessionCountLimit(int sessionCountLimit) {
        this.sessionCountLimit = sessionCountLimit;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public short getDevState() {
        return this.devState;
    }

    public void setDevState(short devState) {
        this.devState = devState;
    }

    public int getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(int accessCode) {
        this.accessCode = accessCode;
    }

    public String getAccessCodeTitle() {
        return this.accessCodeTitle;
    }

    public void setAccessCodeTitle(String accessCodeTitle) {
        this.accessCodeTitle = accessCodeTitle;
    }

    public String getDevStateTitle() {
        if ((Integer)this.parentId > 0) {
            return "";
        }
        switch (this.devState) {
            case -1: {
                return "\u0443\u0434\u0430\u043b\u0435\u043d";
            }
            case 1: {
                return "\u0432\u043a\u043b\u044e\u0447\u0435\u043d";
            }
            case 0: {
                if (this.accessCodeTitle != null) {
                    return "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d [" + this.accessCodeTitle + "]";
                }
                return "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
            }
        }
        return "---";
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getContractObjectId() {
        return this.contractObjectId;
    }

    public void setContractObjectId(int contractObjectId) {
        this.contractObjectId = contractObjectId;
    }

    @Override
    protected boolean isRootNode() {
        return this.isRootNodeWithIntegerId((Integer)this.id, (Integer)this.parentId);
    }
}

