/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.file.FileData;
import org.bgerp.util.Log;
import org.bgerp.util.URLTotalEncoder;
import org.bgerp.util.mail.Addresses;
import org.bgerp.util.mail.MailConfig;

public class MailMsg {
    private static final Log log = Log.getLog();
    private final String encoding;
    private final MimeMessage msg;
    private List<FileData> attachments;

    public static String getParamMailEncoding(ConfigMap config) {
        return config.get("mail.encoding", StandardCharsets.UTF_8.name());
    }

    public static void setAttachFileName(MimeBodyPart part, String filename) throws MessagingException {
        String charset = StandardCharsets.UTF_8.toString();
        Object encoded = URLTotalEncoder.encode(filename, StandardCharsets.UTF_8);
        StringBuilder cd = new StringBuilder(((String)encoded).length() * 2);
        int maxLineLength = 60;
        if (((String)encoded).length() <= 60) {
            cd.append("attachment; filename*=").append(charset).append("''").append((String)encoded);
        } else {
            cd.append("attachment;\r\n");
            encoded = charset + "'" + (String)encoded;
            int cnt = 0;
            while (((String)encoded).length() > 60) {
                String encodedPart = ((String)encoded).substring(0, 60);
                cd.append(" filename*").append(cnt).append("*=");
                if (cnt == 0) {
                    int pos = encodedPart.indexOf("'");
                    cd.append(encodedPart.substring(0, pos + 1)).append(encodedPart.substring(pos));
                } else {
                    cd.append(encodedPart);
                }
                cd.append(";").append("\r\n");
                encoded = ((String)encoded).substring(60);
                ++cnt;
            }
            if (((String)encoded).length() > 0) {
                cd.append(" filename*").append(cnt).append("*=").append((String)encoded);
            }
        }
        part.setHeader("Content-Disposition", cd.toString());
    }

    public MailMsg(ConfigMap config) {
        String fromAddress = config.get("mail.from.email", null);
        String fromName = config.get("mail.from.name", "BGERP");
        if (fromAddress == null) {
            throw new IllegalArgumentException("Parameter 'mail.from.email' not defined in config!");
        }
        this.encoding = MailMsg.getParamMailEncoding(config);
        this.msg = new MimeMessage(new MailConfig(config).getSmtpSession(null));
        try {
            this.msg.setSentDate(new Date());
            this.msg.setFrom((Address)new InternetAddress(fromAddress, fromName, this.encoding));
        }
        catch (MessagingException | UnsupportedEncodingException ex) {
            log.error(ex);
        }
    }

    public MailMsg withAttachments(List<FileData> value) {
        this.attachments = value;
        return this;
    }

    public void send(String recipients, String subject, String txt) throws MessagingException {
        this.msg.setRecipients(Message.RecipientType.TO, (Address[])Addresses.parseSafe(recipients).recipients().get(Message.RecipientType.TO));
        this.msg.setSubject(subject, this.encoding);
        if (this.attachments == null || this.attachments.isEmpty()) {
            this.msg.setText(txt, this.encoding);
        } else {
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            part.setText(txt, this.encoding);
            mp.addBodyPart((BodyPart)part);
            for (FileData attachment : this.attachments) {
                part = new MimeBodyPart();
                MailMsg.setAttachFileName(part, attachment.getTitle());
                part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(attachment.getData(), "application/octet-stream")));
                mp.addBodyPart((BodyPart)part);
            }
            this.msg.setContent((Multipart)mp);
        }
        this.send();
    }

    private void send() throws MessagingException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            this.msg.writeTo((OutputStream)bos);
            log.info("Sending a mail:\n{}", new String(bos.toByteArray(), this.encoding));
        }
        catch (Exception e) {
            log.error(e);
        }
        Transport transport = this.msg.getSession().getTransport();
        transport.connect();
        transport.sendMessage((Message)this.msg, this.msg.getAllRecipients());
        transport.close();
    }
}

